package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import org.hamcrest.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.imagebanners.CreativesConstructorPage;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.imagebanners.blocks.AddHrefToCreativeBannersPopup;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.imagebanners.blocks.LoadImageFromGalleryPopup;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.imagebanners.blocks.LoadImageFromInternetPopup;
import ru.yandex.autotests.direct.web.pages.statistic.WebElementVisibilityState;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.FileInputBEM;
import ru.yandex.qatools.allure.webdriver.rules.WebDriverConfiguration;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.ImagePopup2.POPUP_XPATH;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebDriverUtils.setElementVisibility;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.isExists;

@FindBy(xpath = POPUP_XPATH)
public class ImagePopup2 extends ExtendedHtmlElement implements ImagePopupInterface {

    public final static String POPUP_XPATH = "//div[contains(@class,'popup_visibility_visible')]//div[@class='b-image-add-loader__chooser']";

    @Name("Загрузить с компьютера")
    @FindBy(xpath = ".//div[contains(@class,'b-image-add-loader__chooser-item_type_local')]")
    private WebElement loadFromLocal;

    @Name("Загрузить из интернета")
    @FindBy(xpath = ".//div[contains(@class,'b-image-add-loader__chooser-item_type_external')]")
    private WebElement loadFromInternet;

    @Name("Выбрать изображение из загруженных ранее")
    @FindBy(xpath = ".//div[contains(@class,'b-image-add-loader__chooser-item_type_gallery')]")
    private WebElement loadFromGallery;

    @Name("Выбрать креатив из загруженных ранее")
    @FindBy(xpath = ".//div[contains(@class,'b-image-add-loader__chooser-item_type_constructor-select')]")
    private WebElement loadFromExistingCreative;

    @Name("Создать новый креатив")
    @FindBy(xpath = ".//div[contains(@class,'b-image-add-loader__chooser-item_type_constructor-create')]")
    private WebElement loadFromNewCreative;

    private LoadImageFromInternetPopup loadImageFromInternetPopup;
    private LoadImageFromGalleryPopup loadImageFromGalleryPopup;
    private AddHrefToCreativeBannersPopup addHrefToCreativeBannersPopup;

    public void clickLoadImageFromLocal() {
        loadFromLocal.click();
    }

    public void clickLoadImageFromInternet() {
        loadFromInternet.click();
    }

    public void clickLoadImageFromGallery() {
        loadFromGallery.click();
    }

    public void clickLoadExistingCreative() {
        loadFromExistingCreative.click();
    }

    public void clickLoadNewCreative() {
        loadFromNewCreative.click();
    }

    @Override
    public void loadLocalImage(String imgName) {
        clickLoadImageFromLocal();
        takeScreenshot();
        String filePath = "./img/" + imgName;
        FileInputBEM fileInput = new FileInputBEM(config.getDriver()
                .findElement(By.cssSelector(".i-local-file-uploader")));
        makeFileInputVisible(fileInput);
        fileInput.setFileToUpload(filePath);
        takeScreenshot();
        waitForElement(this.getWrappedElement(), 5, not(WebElementMatchers.isDisplayed()));
    }

    @Override
    public void loadImageFromInternet(String imgUrl) {
        clickLoadImageFromInternet();
        getLoadImageFromInternetPopup().loadImageFromInternet(imgUrl);
        waitForElement(getLoadImageFromInternetPopup(), 5, not(WebElementMatchers.isDisplayed()));
    }

    @Override
    public void loadImageFromGallery(String imgHash) {
        clickLoadImageFromGallery();
        getLoadImageFromGalleryPopup().loadGalleryImage(imgHash);
        waitForElement(getLoadImageFromGalleryPopup(), 5, not(WebElementMatchers.isDisplayed()));
    }

    @Override
    public void loadImageNewCreative(String imgName) {
        clickLoadNewCreative();
        try {
            Thread.sleep(5000);
        }
        catch (Exception e) {
            throw new DirectWebError("ошибка при попытке переключиться в конструктор креативов");
        }
        takeScreenshot();
        getCreativesConstructorPage().createCreative(imgName);
        checkPopupCreative();
    }

    @Override
    public void loadImageExistingCreative(String imgName) {
        clickLoadExistingCreative();
        try {
            Thread.sleep(5000);
        }
        catch (Exception e) {
            throw new DirectWebError("ошибка при попытке переключиться в конструктор креативов");
        }
        takeScreenshot();
        getCreativesConstructorPage().addCreativeFromGalleryByName(imgName);
        checkPopupCreative();
    }

    private void makeFileInputVisible(FileInputBEM input) {
        setElementVisibility(config.getDriver(), input.getWrappedElement(), WebElementVisibilityState.VISIBLE);
        ((JavascriptExecutor) config.getDriver())
                .executeScript("var s = arguments[0].style;s.top='0px';s.left='0px'", input);
    }

    private void checkPopupCreative() {
        config.getDriver().switchTo().defaultContent();
        if (isExists(getAddHrefToCreativeBannersPopup()) && getAddHrefToCreativeBannersPopup().isDisplayed()) {
            getAddHrefToCreativeBannersPopup().clickSaveButton();
        }
        waitForElement(getAddHrefToCreativeBannersPopup(), 5, not(WebElementMatchers.isDisplayed()));
    }

    private LoadImageFromInternetPopup getLoadImageFromInternetPopup() {
        loadImageFromInternetPopup.setConfig(config);
        HtmlElementLoader.populate(loadImageFromInternetPopup, config.getDriver());
        return loadImageFromInternetPopup;
    }

    private LoadImageFromGalleryPopup getLoadImageFromGalleryPopup() {
        loadImageFromGalleryPopup.setConfig(config);
        HtmlElementLoader.populate(loadImageFromGalleryPopup, config.getDriver());
        return loadImageFromGalleryPopup;
    }

    private CreativesConstructorPage getCreativesConstructorPage() {
        return CreativesConstructorPage.getInstance(CreativesConstructorPage.class, config);
    }

    private AddHrefToCreativeBannersPopup getAddHrefToCreativeBannersPopup() {
        addHrefToCreativeBannersPopup.setConfig(config);
        HtmlElementLoader.populate(addHrefToCreativeBannersPopup, config.getDriver());
        return addHrefToCreativeBannersPopup;
    }

    //Заглушка, метод указан в интерфейсе для другого класса
    @Override
    public void checkImage(Matcher matcher) {
        throw new UnsupportedOperationException();
    }

    //Заглушка, метод указан в интерфейсе для другого класса
    @Override
    public void removeImg() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setConfig(WebDriverConfiguration config) {
        this.config = config;
    }
}