package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import org.hamcrest.Matcher;
import org.openqa.selenium.By;

import ru.yandex.autotests.direct.web.data.banners.ImageLoadType;
import ru.yandex.autotests.direct.web.objects.imagead.ImageAdWeb;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.ImagePopup2.POPUP_XPATH;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;

public class ImagePopupSteps extends BaseSteps {

    private ImagePopupInterface imagePopup;

    public ImagePopupInterface populateImagePopup() {
        if (config.getDriver().findElements(
                By.xpath(POPUP_XPATH))
                .isEmpty())
        {
            imagePopup = new ImagePopup1();
        } else {
            imagePopup = new ImagePopup2();
        }
        imagePopup.setConfig(config);
        HtmlElementLoader.populate(imagePopup, config.getDriver());
        return imagePopup;
    }

    @Step("Выбираем способ загрузки картинки")
    public void loadImage(ImageLoadType type, String img) {
        populateImagePopup();
        switch (type) {
            case LOCAL:
                imagePopup.loadLocalImage(img);
                break;
            case WWW:
                imagePopup.loadImageFromInternet(img);
                break;
            case GALLERY:
                imagePopup.loadImageFromGallery(img);
                break;
        }
        waitForElement(imagePopup, 5, not(WebElementMatchers.isDisplayed()));
    }

    @Step("Выбираем способ загрузки картинки для ГО")
    public void loadAdImage(ImageAdWeb imgAd) {
        populateImagePopup();
        switch (imgAd.getImageAdLoadType()) {
            case LOCAL:
                imagePopup.loadLocalImage(imgAd.getImageAdLocalFileName());
                break;
            case WWW:
                imagePopup.loadImageFromInternet(imgAd.getImageAdUrl());
                break;
            case GALLERY:
                imagePopup.loadImageFromGallery(imgAd.getImageAdPictureHash());
                break;
            case NEW_CREATIVE:
                imagePopup.loadImageNewCreative(imgAd.getImageAdPictureName());
                break;
            case EXISTING_CREATIVE:
                imagePopup.loadImageExistingCreative(imgAd.getImageAdPictureName());
                break;
        }
    }

    @Step("Проверяем картинку")
    public void checkImage(Matcher matcher) {
        populateImagePopup().checkImage(matcher);
    }

    @Step("Удаляем картинку")
    public void removeImg() {
        populateImagePopup().removeImg();
    }
}