package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.List;
import java.util.function.Predicate;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.commons.InterestInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static com.google.common.collect.Iterables.getLast;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static ru.yandex.autotests.direct.web.util.StringHelper.getNumericDataFromText;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@FindBy(xpath = "//div[contains(@class, 'popup__content')]/div[contains(@class, 'b-edit-interests-targeting')]")
public class InterestPopup extends ExtendedHtmlElement {
    @Name("Инпут 'Найти'")
    @FindBy(xpath = ".//span[contains(@class, 'b-chooser__search')]")
    private TextInput searchInput;

    @Name("Чекбокс 'Выбрать все'")
    @FindBy(xpath = ".//span[contains(@class, 'b-chooser__select-all')]//input")
    private CheckBox selectAll;

    @Name("Невыбранные интересы")
    @FindBy(xpath = ".//div[contains(@class, 'b-edit-interests-targeting-item_js')]")
    private List<WebElement> notSelectedInterests;

    @Name("Выбранные интересы")
    @FindBy(xpath = ".//div[contains(@class, 'b-selected-items-list__item')]"
            + "/div[contains(@class, 'b-edit-interests-targeting__selected-item')]")
    private List<WebElement> selectedInterests;

    @Name("Кнопка 'Сохранить'")
    @FindBy(xpath = ".//button[contains(@class, 'b-edit-interests-targeting__save')]")
    private Button saveInterests;

    @Name("Кнопка 'Отмена'")
    @FindBy(xpath = ".//button[contains(@class, 'b-edit-interests-targeting__cancel')]")
    private Button cancelButton;

    public List<Long> getSelectedInterestsIds() {
        return selectedInterests.stream()
                .map(i -> getLast(getNumericDataFromText(i.getAttribute("data-bem"))))
                .collect(toList());
    }

    public void clickSave() {
        saveInterests.click();
    }

    public void clickCancel() {
        cancelButton.click();
    }

    public void fillParameters(List<InterestInfoWeb> interests) {
        if (interests == null) {
            return;
        }
        String pattern = ".*id\":\"(" +
                interests.stream()
                        .map(i -> i.getId().toString())
                        .collect(joining("|"))
                + ")\".*";
        Predicate<WebElement> shouldBeSelected = el -> el.getAttribute("data-bem").matches(pattern);
        selectedInterests.stream()
                .filter(shouldBeSelected.negate())
                .forEach(el -> el.findElement(By.xpath(".//button")).click());
        notSelectedInterests.stream()
                .filter(shouldBeSelected)
                .forEach(WebElement::click);
    }

    public void checkParameters(List<InterestInfoWeb> interests) {
        if (interests == null) {
            return;
        }
        assertThat("id выбранных интересов соответствует ожиданию", getSelectedInterestsIds(),
                containsInAnyOrder(interests.stream().map(InterestInfoWeb::getId).collect(toList())));
    }
}
