package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.webelements.bem.TextAreaBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 01.06.14
 */

@Name("Попап минус-слов")
@FindBy(xpath = "//div[contains(@class, 'visible')]/div[contains(@class, 'popup__content') " +
        "and .//div[contains(@class, 'b-minus-words')]]")
public class MinusWordsPopupBEM extends ExtendedHtmlElement {

    @Name("Поле минус-слов")
    @FindBy(xpath = ".//textarea")
    private TextAreaBEM minusKeywordsTextInput;

    @Name("Сохранить")
    @FindBy(xpath = ".//button[contains(@class, 'accept')]")
    private Button saveButton;

    @Name("Отменить")
    @FindBy(xpath = ".//button[contains(@class, 'decline')]")
    private Button cancelButton;

    public void fillMinusKeywordsTextInput(String[] minusKeyWords) {
        fillTextInput(minusKeywordsTextInput, StringUtils.join(minusKeyWords, ", "));
        new JavaScriptActions(config).fireKeyUpEvent(minusKeywordsTextInput.getWrappedElement());
        new JavaScriptActions(config).fireChangeEvent(minusKeywordsTextInput.getWrappedElement());
        new JavaScriptActions(config).fireBlurEvent(minusKeywordsTextInput.getWrappedElement());
    }

    public List<String> getMinusWords() {
        return Arrays.asList(minusKeywordsTextInput.getText().replaceFirst("-", "").split("\\s-"));
    }

    public void clickOnSaveButton() {
        saveButton.click();
    }

    public void clickOnCancelButton() {
        cancelButton.click();
    }
}
