package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.hamcrest.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.cmd.data.commons.banner.HashFlags;
import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.data.RadioInputMethod;
import ru.yandex.autotests.direct.web.data.banners.DirectBannerType;
import ru.yandex.autotests.direct.web.data.banners.ImageLoadType;
import ru.yandex.autotests.direct.web.data.banners.MobileBannerAdditionalEnum;
import ru.yandex.autotests.direct.web.objects.banners.MobileAppBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.imagead.ImageAdWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.util.StringHelper;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.bem.ImageAdRadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.MobileAppAdditionsSelect;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBlockBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TextAreaBEM;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ch.lambdaj.Lambda.on;
import static com.google.common.collect.Iterables.getLast;
import static java.util.Objects.isNull;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillRadio;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

@FindBy(xpath = ".//div[contains(@class, 'b-edit-banner2 ')]")
public class MobileAppBannerBlockBEM extends ExtendedHtmlElement implements IWebFrom<MobileAppBannerInfoWeb> {

    private ImagePopupSteps onImagePopup() {
        return BaseSteps.getInstance(ImagePopupSteps.class, config);
    }

    //region Fields

    @Name("Заголовок")
    @FindBy(xpath = ".//input[@name = 'title']")
    private TextInput bannerTitle;

    @Name("Текст объявления")
    @FindBy(xpath = ".//textarea[@name = 'body']")
    private TextAreaBEM bannerBodyText;

    @Name("Трекинговая ссылка")
    @FindBy(xpath = ".//div[contains(@class, 'b-mobile-content-tracking-href')]//textarea")
    private TextAreaBEM trackingHref;

    @Name("Возрастные ограничения")
    @FindBy(xpath = ".//input[@name = 'mobile_content_banner_age_label']")
    private RadioBlockBEM ageRadio;

    @Name("Превью баннера мобильных приложений")
    @FindBy(css = "div.b-banner-preview2_type_mobile-content")
    private MobileAppBannerPreviewBlockBEM mobileAppBannerPreviewBlock;

    @Name("Переключатель типа баннера")
    @FindBy(xpath = ".//div[contains(@class,'b-edit-banner2__ad-type')]//input")
    protected ImageAdRadioBEM bannerType;

    @Name("Выбранный тип баннера")
    @FindBy(xpath = ".//div[@class='b-edit-banner2__text-wrap']")
    private WebElement selectedBannerType;

    @Name("Кнопка изменения графического объявления")
    @FindBy(xpath = ".//div[contains(@class, 'b-image-add-loader')]//button")
    private Button editImageAdButton;

    @Name("Картинка из графического объявления")
    @FindBy(xpath = ".//div[contains(@class,'b-image-add-loader__sign-content')]")
    private WebElement imageAdPicture;

    @Name("Переключатель вкладки превью")
    @FindBy(xpath = ".//div[contains(@class,'b-banner-preview-filter2')]//input")
    protected RadioBEM previewType;

    @Name("Превью объявления")
    @FindBy(xpath = ".//div[contains(@class,'b-edit-banner2__banner-viewer')]")
    private WebElement bannerPreview;

    @Name("Кнопка изменить изображение")
    @FindBy(xpath = ".//div[contains(@class, 'b-banner-pic__outboard')]//button")
    private Button editImageButton;

    @Name("Метка 'объявление'")
    @FindBy(xpath = ".//div[@class='b-edit-banner2__label-text']")
    private WebElement bannerLabel;

    @Name("Поля для показа в объявлении")
    @FindBy(css = ".b-mobile-content-additions__attrs-select button")
    private WebElement bannerAdditions;

    @Name("Попап для выбора дополнений к объявлению")
    private MobileAppAdditionsSelect additionsPopup;

    private void inputTitle(String title) {
        if (title == null) {
            return;
        }
        bannerTitle.getWrappedElement().click();
        bannerTitle.clear();
        bannerTitle.sendKeys(title);
    }

    private void inputText(String text) {
        if (text == null) {
            return;
        }
        bannerBodyText.click();
        bannerBodyText.clear();
        bannerBodyText.sendKeys(text);
    }

    private void inputTrackingHref(String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        trackingHref.getWrappedElement().click();
        fillTextInput(trackingHref, text);
        new JavaScriptActions(config).fireKeyUpEvent(trackingHref.getWrappedElement());
        new JavaScriptActions(config).fireChangeEvent(trackingHref.getWrappedElement());
        new JavaScriptActions(config).fireBlurEvent(trackingHref.getWrappedElement());
    }

    private void selectAge(String age) {
        if (age == null) {
            return;
        }

        ageRadio.selectByValue(age);
    }

    private void setHashFlags(HashFlags hashFlags) {
        if (hashFlags == null) {
            return;
        }
        selectAge(hashFlags.getAge());
    }

    public void checkImageAdPicture(ImageAdWeb imageAd) {
        if (imageAd == null) {
            return;
        }
        String imageAdOnPage = getImageAd().getImageAdPictureName();
        assertThat("картинка соответствует ожиданиям", imageAdOnPage, equalTo(imageAd.getImageAdPictureName()));
    }

    public DirectBannerType getBannerType() {
        if (WebElementMatchers.exists().matches(selectedBannerType)) {
            return DirectBannerType.getDirectBannerTypeByTextDescription(selectedBannerType.getText());
        }
        return DirectBannerType.getDirectBannerTypeByValue(bannerType.getSelectedValue());
    }

    public void checkBannerType(DirectBannerType type) {
        if (type == null) {
            return;
        }
        assertThat("тип баннера соответствует ожидаемому", getBannerType(), equalTo(type));
    }

    public void fillBannerType(DirectBannerType bannersType) {
        if (bannersType == null) {
            return;
        }
        bannerType.selectByValue(bannersType.toString());
    }

    public void fillImageAdPictureAndSave(ImageAdWeb imgAd) {
        if (imgAd == null) {
            return;
        }
        editImageAdButton.click();
        onImagePopup().loadAdImage(imgAd);
    }

    public void fillImageAndSave(ImageLoadType type, String img) {
        editImageButton.click();
        onImagePopup().loadImage(type, img);
    }

    public void checkImageOnPopup(Matcher matcher) {
        editImageButton.click();
        onImagePopup().checkImage(matcher);
    }

    public void fillMobileAppBannerAdditions(List<MobileBannerAdditionalEnum> mobileBannerAdditions) {
        if (isNull(mobileBannerAdditions)) {
            return;
        }

        bannerAdditions.click();
        waitForElement(additionsPopup, 2, WebElementMatchers.isDisplayed());
        takeScreenshot();

        if (mobileBannerAdditions.isEmpty()) {
            additionsPopup.uncheckAllValues();
        }
        else {
            additionsPopup.selectValues(mobileBannerAdditions);
        }
        takeScreenshot();
        bannerAdditions.click();
    }

    @Override
    public void fillParameters(MobileAppBannerInfoWeb bannerInfo) {
        fillBannerType(bannerInfo.getBannerType());
        inputTitle(bannerInfo.getTitle());
        inputText(bannerInfo.getBody());
        inputTrackingHref(bannerInfo.getTrackingHref());
        setHashFlags(bannerInfo.getHashFlags());
        fillImageAdPictureAndSave(bannerInfo.getImageAd());
        fillMobileAppBannerAdditions(bannerInfo.getBannerAdditionalItems());
    }

    @Override
    public void checkParameters(MobileAppBannerInfoWeb expectedBean) {
    }

    public void checkMobileAppBannerPreviewParameters(MobileAppBannerInfoWeb expectedBean) {
        mobileAppBannerPreviewBlock.checkParameters(expectedBean);
    }

    @Override
    public MobileAppBannerInfoWeb getFormFieldsAccording(MobileAppBannerInfoWeb expectedBean) {
        MobileAppBannerInfoWeb bannerInfo = inAccordanceWith(expectedBean).forNew(MobileAppBannerInfoWeb.class)
                .set("bannerType", this, on(MobileAppBannerBlockBEM.class).getBannerType())
                .set("title", bannerTitle, on(TextInput.class).getText())
                .set("body", bannerBodyText, on(TextAreaBEM.class).getText())
                .set("trackingHref", this, on(MobileAppBannerBlockBEM.class).getTrackingHref())
                .set("hashFlags", this, on(MobileAppBannerBlockBEM.class).getHashFlags())
                .set("imageAd", this, on(MobileAppBannerBlockBEM.class).getImageAd())
                .set("bannerAdditionalItems", this, on(MobileAppBannerBlockBEM.class).getBannerAdditions())
                .getActualBean();
        bannerInfo.setBannerId(getBannerId());
        bannerInfo.setCampaignID(expectedBean.getCampaignID());
        return bannerInfo;
    }

    //endregion

    //region Field getters

    public String getTrackingHref() {
        return trackingHref.getText();
    }

    public HashFlags getHashFlags() {
        HashFlags hashFlags = new HashFlags();
        hashFlags.setAge(ageRadio.getSelectedButton().getAttribute("value"));

        return hashFlags;
    }

    public Long getBannerId() {
        return getLast(StringHelper.getNumericDataFromText(bannerLabel.getAttribute("id")));
    }

    public ImageAdWeb getImageAd() {
        ImageAdWeb imageAd = new ImageAdWeb();
        imageAd.setImageAdPictureName(imageAdPicture.getText());
        return imageAd;
    }

    public List<MobileBannerAdditionalEnum> getBannerAdditions() {
        String[] textAdditions = bannerAdditions.findElement(By.xpath(".//span[contains(@class, 'button2__text')]"))
                .getText().split(", ");
        return java.util.stream.Stream.of(textAdditions)
                .map(x -> MobileBannerAdditionalEnum.getByTextValue(x)).collect(Collectors.toList());
    }

    public void clickBannerPreviewType(BannerPreviewType prevType) {
        if (previewType == null) {
            return;
        }
        fillRadio(previewType, prevType.toString(), RadioInputMethod.BY_VALUE);
    }

    public WebElement getBannerPreview() {
        return bannerPreview;
    }

    public void openImagePopop() {
        editImageButton.click();
    }

    //endregion
}
