package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.data.banners.ReflectedAttrsEnum;
import ru.yandex.autotests.direct.web.objects.banners.GroupMobileInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.MobileAppBannerInfoWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath.newPath;
import static ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies.onlyFields;
import static ru.yandex.qatools.matchers.webdriver.ExistsMatcher.exists;

/**
 * Created by aleran on 13.10.2015.
 */
public class MobileAppBannerPreviewBlockBEM extends HtmlElement {

    @Name("Ид баннера")
    @FindBy(xpath = ".//div[contains(@class,'banner-id')]")
    private WebElement bannerID;

    @Name("Заголовок баннера")
    @FindBy(xpath = ".//div[contains(@class,'title')]/a")
    private Link titleLink;

    @Name("Иконка")
    @FindBy(xpath = ".//div[contains(@class,'mobile-content-icon')]")
    private WebElement icon;

    @Name("Текст баннера")
    @FindBy(xpath = ".//div[@class = 'b-banner-preview2__body']")
    private WebElement bodyText;

    @Name("Рейтинг")
    @FindBy(xpath = ".//div[contains(@class,'mobile-content-rating')]")
    private WebElement rating;

    @Name("Рейтинг Кол-во")
    @FindBy(xpath = ".//a[contains(@class,'rating-count')]")
    private WebElement ratingCount;

    @Name("Цена")
    @FindBy(xpath = ".//div[contains(@class,'action-button')]")
    private WebElement price;

    private Long getBannerId() {
        Pattern pattern = Pattern.compile("№ M-(\\d+)");
        Matcher matcher = pattern.matcher(bannerID.getText());
        if (matcher.find()) {
            return Long.parseLong(matcher.group(1));
        } else {
            throw new DirectWebError("Cannot find banner Id");
        }
    }

    public String getTrackingHref() {
        return titleLink.getReference().contains("itunes") || titleLink.getReference().contains("play.google")
                ? null : titleLink.getReference();
    }

    public String getStoreHref() {
        return titleLink.getReference().contains("itunes") || titleLink.getReference().contains("play.google")
                ? titleLink.getReference() : null;
    }

    private String getRatings() {
        if (exists().matches(rating)) {
            return ReflectedAttrsEnum.RATING.getValue();
        }
        return null;
    }

    private String getRatingCounts() {
        if (exists().matches(ratingCount)) {
            return ReflectedAttrsEnum.RATING_VOTES.getValue();
        }
        return null;
    }

    private String getIcon() {
        if (exists().matches(icon)) {
            return ReflectedAttrsEnum.ICON.getValue();
        }
        return null;
    }

    private String getPrice() {
        if (price.getText().replaceAll("[^0-9]", "").length() > 0) {
            return ReflectedAttrsEnum.PRICE.getValue();
        }
        return null;
    }

    public List<String> getReflectedAttrs() {
        List<String> reflectedAttrs = new ArrayList<>();
        reflectedAttrs.add(getRatings());
        reflectedAttrs.add(getIcon());
        reflectedAttrs.add(getRatingCounts());
        reflectedAttrs.add(getPrice());
        return reflectedAttrs;
    }

    public void checkParameters(MobileAppBannerInfoWeb expectedBean) {
        assertThat("неверный превью баннера", getFormFieldsAccording(expectedBean), beanDiffer(expectedBean)
                .useCompareStrategy(onlyFields(
                        newPath("title"), newPath("body"), newPath("trackingHref"), newPath("reflectedAttrs"),
                        newPath("groupMobileInfo","storeContentHref"), newPath("bannerID"))));
    }

    public MobileAppBannerInfoWeb getFormFieldsAccording(MobileAppBannerInfoWeb expectedBean) {
        MobileAppBannerInfoWeb actualBean = inAccordanceWith(expectedBean).forNew(MobileAppBannerInfoWeb.class)
                .set("title", titleLink, on(Link.class).getText())
                .set("body", bodyText, on(WebElement.class).getText())
                .set("trackingHref", this, on(MobileAppBannerPreviewBlockBEM.class).getTrackingHref())
                .set("reflectedAttrs", this, on(MobileAppBannerPreviewBlockBEM.class).getReflectedAttrs())
                .getActualBean();
        if (expectedBean.getBannerId() == 0) {
            actualBean.setBannerId(0L);
        } else {
            actualBean.setBannerId(getBannerId());
        }
        actualBean.setAdGroupID(expectedBean.getAdGroupID());
        if (actualBean.getTrackingHref() != null) {
            actualBean.setGroupMobileInfo(expectedBean.getGroupMobileInfo());
        } else {
            actualBean.setGroupMobileInfo(new GroupMobileInfoWeb().withStoreContentHref(getStoreHref()));
        }
        actualBean.setCampaignID(expectedBean.getCampaignID());
        return actualBean;
    }


}
