package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.RadioInputMethod;
import ru.yandex.autotests.direct.web.data.banners.MobileGroupChangesBlockTabs;
import ru.yandex.autotests.direct.web.data.banners.MobileGroupChangesInfo;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.allure.webdriver.steps.AlertSteps;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static java.lang.String.format;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillRadio;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * Created by aleran on 28.09.2015.
 */
@FindBy(xpath = "//div[contains(@class, 'b-edit-groups-mass-actions_type_mobile-content')]")
public class MobileGroupChangesBlockBEM extends ExtendedHtmlElement {
    private AlertSteps onAlert() {
        return BaseSteps.getInstance(AlertSteps.class, config);
    }

    @Name("Вкладки групповых действий")
    @FindBy(xpath = ".//div[contains(@class, 'b-chooser__item_name_')]/div")
    public List<WebElement> tabs;

    @Name("'Найти:' на вкладке Часть текста")
    @FindBy(xpath = ".//input[@name = 'text-from']")
    private TextInput textFromInput;

    @Name("Заменить на: на вкладке Часть текста")
    @FindBy(xpath = ".//input[@name = 'text-to']")
    private TextInput textToInput;

    @Name("Кнопка обновить текст на вкладке 'Часть текста'")
    @FindBy(xpath = ".//button[@name = 'update-text']")
    private Button updateTextButton;

    @Name("Дополнительный параметр: Иконка")
    @FindBy(xpath = ".//input[@name = 'icon']")
    private RadioBEM iconUrlParamRadio;

    @Name("Дополнительный параметр: Рейтинг")
    @FindBy(xpath = ".//input[@name = 'rating']")
    private RadioBEM ratingParamRadio;

    @Name("Дополнительный параметр: Количество оценок")
    @FindBy(xpath = ".//input[@name = 'rating_votes']")
    private RadioBEM ratingVotesParamRadio;

    @Name("Дополнительный параметр: Цена")
    @FindBy(xpath = ".//input[@name = 'price']")
    private RadioBEM priceParamRadio;

    @Name("Кнопка применить на вкладке 'Дополнительные параметры'")
    @FindBy(xpath = ".//button[@name = 'set-mobile-content-additions']")
    private Button setMobileContentAdditionsButton;

    @Name("Новая трекинговая ссылка")
    @FindBy(xpath = ".//input[@name = 'new-tracking-href']")
    private TextInput newTrackingLinkTextInput;

    @Name("Кнопка Изменить ссылку на вкладке 'Трекинговая ссылка'")
    @FindBy(xpath = ".//button[@name = 'new-tracking-href']")
    private Button newTrackingLinkButton;

    @Name("Найти: на вкладке Часть ссылки")
    @FindBy(xpath = ".//input[@name = 'tracking-href-from']")
    private TextInput trackingLinkFrom;

    @Name("Заменить на: на вкладке Часть ссылки")
    @FindBy(xpath = ".//input[@name = 'tracking-href-to']")
    private TextInput trackingLinkTo;

    @Name("Кнопка Изменить часть ссылки на вкладке 'Часть ссылки'")
    @FindBy(xpath = ".//button[@name = 'replace-tracking-href-part']")
    private Button replaceTrackingLinkPartButton;

    @Name("Кнопки 'Отмена' на всех вкладках")
    @FindBy(xpath = ".//button[contains(@name, 'cancel')]")
    private List<Button> closeButtons;

    public Button getCloseButton() {
        return WebElementsActions.getVisibleElement(closeButtons);
    }

    public void openGroupChangesTab(MobileGroupChangesBlockTabs mobileGroupChangesBlockTabs) {
        tabs.stream()
                .filter(x -> x.getText().equals(mobileGroupChangesBlockTabs.toString()))
                .findFirst()
                .orElseThrow(
                        () -> new DirectWebError(format("Таб %s не найден", mobileGroupChangesBlockTabs.toString())))
                .click();
    }

    public void fill(MobileGroupChangesInfo mobileGroupChangesInfo) {
        openGroupChangesTab(mobileGroupChangesInfo.getTab());
        switch (mobileGroupChangesInfo.getTab()) {
            case TEXT_PART:
                fillTextInput(textFromInput, mobileGroupChangesInfo.getTextPartFindBy());
                fillTextInput(textToInput, mobileGroupChangesInfo.getTextPartReplaceWith());
                takeScreenshot();
                updateTextButton.click();
                break;
            case ADDITION_PARAMS:
                fillRadio(iconUrlParamRadio, mobileGroupChangesInfo.getIconUrlShowRule().getValue(),
                        RadioInputMethod.BY_VALUE);
                fillRadio(ratingParamRadio, mobileGroupChangesInfo.getRatingShowRule().getValue(),
                        RadioInputMethod.BY_VALUE);
                fillRadio(ratingVotesParamRadio, mobileGroupChangesInfo.getRatingVotesShowRule().getValue(),
                        RadioInputMethod.BY_VALUE);
                fillRadio(priceParamRadio, mobileGroupChangesInfo.getPriceShowRule().getValue(),
                        RadioInputMethod.BY_VALUE);
                takeScreenshot();
                setMobileContentAdditionsButton.click();
                break;
            case NEW_TRACKING_LINK:
                fillTextInput(newTrackingLinkTextInput, mobileGroupChangesInfo.getNewTrackingLink());
                takeScreenshot();
                newTrackingLinkButton.click();
                break;
            case TRACKING_LINK_PART:
                fillTextInput(trackingLinkFrom, mobileGroupChangesInfo.getTrackingLinkPartFindBy());
                fillTextInput(trackingLinkTo, mobileGroupChangesInfo.getTrackingLinkPartReplaceWith());
                takeScreenshot();
                replaceTrackingLinkPartButton.click();
                break;
        }
    }
}
