package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.banners.PerformanceGroupChangesBlockTabs;
import ru.yandex.autotests.direct.web.data.banners.PerformanceGroupChangesInfo;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBlockBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static java.lang.String.format;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;

@FindBy(xpath = "//div[contains(@class, 'b-edit-groups-mass-actions_type_performance')]")
public class PerformanceGroupChangesBlockBEM extends ExtendedHtmlElement {

    @Name("Вкладки групповых действий")
    @FindBy(xpath = ".//div[contains(@class, 'b-chooser__item_name_')]/div")
    public List<WebElement> tabs;

    @Name("Выпадающий список 'Целевая аудитория' на вкладке 'Целевая аудитория'")
    @FindBy(xpath = ".//span[contains(@class, 'b-feed-filter-target-funnel__select')]/select")
    private SelectBEM targetAudience;

    @Name("Кнопка 'Изменить целевую аудиторию' на вкладке 'Целевая аудитория'")
    @FindBy(xpath = ".//button[@name='change-target-funnel']")
    private Button changeTargetAudience;

    @Name("Переключатель 'В наличии' на вкладке 'Дерево категорий: наличие'")
    @FindBy(xpath = ".//span[contains(@class, 'condition-tree-available-control')]//input[@class = 'radio-button__control']")
    private RadioBlockBEM availableControl;

    @Name("Кнопка 'изменить условие дерева категорий' на вкладке 'Дерево категорий: наличие'")
    @FindBy(xpath = ".//button[contains(@class,'condition-tree-available')]")
    private Button changeAvailabilityControl;

    @Name("Поле 'Диапазон цен'(нижняя граница) на вкладке 'Дерево категорий: диапазон цен'")
    @FindBy(xpath = ".//span[contains(@class,'input_name_min')]//input")
    private TextInput priceLowBoundary;

    @Name("Поле 'Диапазон цен'(верхняя граница) на вкладке 'Дерево категорий: диапазон цен'")
    @FindBy(xpath = ".//span[contains(@class,'input_name_max')]//input")
    private TextInput priceHighBoundary;

    @Name("Кнопка 'изменить условие дерева категорий' на вкладке 'Дерево категорий: диапазон цен'")
    @FindBy(xpath = ".//button[contains(@class,'condition-tree-price')]")
    private Button changePriceBoundaries;

    @Name("Чекбокс 'Выбрать все категории' на вкладке 'список категорий'")
    @FindBy(xpath = ".//span[contains(@class,'condition-tree-all-control')]//input")
    private CheckBoxBEM selectAllCategories;

    @Name("Кнопка 'изменить условие дерева категорий' на вкладке 'список категорий'")
    @FindBy(xpath = ".//button[@name='change-condition-tree-all']")
    private Button changeSelectAllCategories;

    @Name("Кнопки 'Отмена' на всех вкладках")
    @FindBy(xpath = ".//button[contains(@name, 'cancel')]")
    private List<Button> cancelButtons;

    public void clickOnCancelButton() {
        getVisibleElement(cancelButtons).click();
    }

    public void openGroupChangesTab(PerformanceGroupChangesBlockTabs groupChangesBlockTabs) {
        tabs.stream()
                .filter(x -> x.getText().equals(groupChangesBlockTabs.toString()))
                .findFirst()
                .orElseThrow(() -> new DirectWebError(format("Таб %s не найден", groupChangesBlockTabs.toString())))
                .click();
    }

    public void fill(PerformanceGroupChangesInfo changesInfo) {
        openGroupChangesTab(changesInfo.getTargetTab());
        switch (changesInfo.getTargetTab()) {
            case TARGETING_AUDIENCE:
                targetAudience.selectByValue(changesInfo.getTargetingAudience().getValue());
                takeScreenshot();
                changeTargetAudience.click();
                break;
            case AVAILABILITY:
                availableControl.selectByValue(changesInfo.getAvailability().getValue());
                takeScreenshot();
                changeAvailabilityControl.click();
                break;
            case PRICE_RANGE:
                fillTextInput(priceLowBoundary, changesInfo.getPriceLowBoundary());
                fillTextInput(priceHighBoundary, changesInfo.getPriceHighBoundary());
                changePriceBoundaries.click();
                takeScreenshot();
                break;
            case CATEGORIES_LIST:
                if (changesInfo.isSelectAllCategories()) {
                    selectAllCategories.select();
                } else {
                    selectAllCategories.deselect();
                }
                takeScreenshot();
                changeSelectAllCategories.click();
        }
    }

}
