package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 01.06.14
 */
@FindBy(xpath = ".//div[contains(@class, 'b-group-retargeting-condition ')]")
public class RetargetingConditionRowBEM extends HtmlElement {
    @Name("Кнопка удаления условия")
    @FindBy(xpath = ".//span[contains(@class, 'b-group-retargeting-condition__remove')]")
    private WebElement deleteButton;

    @Name("Номер условия")
    @FindBy(xpath = ".//span[contains(@class, 'num')]")
    private WebElement conditionNumber;

    @Name("Название условия")
    @FindBy(xpath = ".//span[contains(@class, 'b-group-retargeting-condition__name')]")
    private WebElement conditionName;

    public void clickDelete() {
        deleteButton.click();
    }

    public void clickOnName() {
        conditionName.click();
    }

    public String getConditionNameText() {
        return conditionName.getText();
    }
}
