package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 01.06.14
 */
@Name("Попап с метками")
@FindBy(xpath = "//div[contains(@class, 'visible')]/div[.//div[contains(@class,'b-group-tags')]]")
public class TagsPopupBlockBEM extends HtmlElement {

    @Name("Новые метки")
    @FindBy(xpath = ".//span[contains(@class, 'input__box')]/input")
    private TextInput tagsTextInput;

    @Name("Сохранить")
    @FindBy(xpath = ".//button[contains(@class, 'accept') or contains(@class, 'save')]")
    private Button saveButton;

    @Name("Список чекбоксов тэгов")
    @FindBy(xpath = ".//input[@type = 'checkbox']")
    public List<CheckBox> checkBoxes;

    public void fillTagsTextInput(List<String> tags) {
        fillTextInput(tagsTextInput, StringUtils.join(tags, ","));
    }

    public void clickOnSaveButton() {
        saveButton.click();
    }

    public void deselectAllTags() {
        for (CheckBox checkBox : checkBoxes) {
            checkBox.deselect();
        }
    }
}
