package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.commons.TurboLandingInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.turbolandigs.ChooseTurbolandingsModePopup;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.turbolandigs.TurboLandingsPopup;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;

@FindBy(xpath = ".//div[contains(@class, 'b-turbo-landings-selector__selector')]")
public class TurboLandingBlockBEM extends ExtendedHtmlElement {

    @Name("Кнопка попап турболендингов")
    @FindBy(xpath = ".//button[contains(@class, 'b-turbo-landings-selector__button-select')]")
    private Button turboLandingsPopupButton;

    @Name("Кнопка удаления турболендинга")
    @FindBy(xpath = ".//button[contains(@class, 'b-turbo-landings-selector__button-delete')]")
    private Button removeTurboLandingButton;

    private ChooseTurbolandingsModePopup chooseTurbolandingModePopup;

    private void switchToTurboLandingPopup() {
        config.getDriver().switchTo().frame(config.getDriver()
                .findElement(By.xpath("//iframe[@class='b-banner-storage-frame__iframe']")));
    }

    private TurboLandingsPopup getTurboLandingsPopupBlock() {
        return TurboLandingsPopup.getInstance(TurboLandingsPopup.class, config);
    }

    private void removeTurboLanding() {
        if (removeTurboLandingButton.isDisplayed()) {
            removeTurboLandingButton.click();
        } else {
            throw new DirectWebError("Отсутствует добавленный турболендинг!");
        }
    }

    public void fillTurboLanding(TurboLandingInfoWeb turboLandingInfoWeb) {
        if (turboLandingInfoWeb != null) {
            if (turboLandingInfoWeb == TurboLandingInfoWeb.DISABLED_TURBOLANDING) {
                removeTurboLanding();
            } else {
                turboLandingsPopupButton.click();
                if (chooseTurbolandingModePopup.getLibraryIcon().isDisplayed()) {
                    chooseTurbolandingModePopup.chooseFromGallery();
                }
                switchToTurboLandingPopup();
                getTurboLandingsPopupBlock().waitUntilRowsWillBeLoaded();
                getTurboLandingsPopupBlock().selectTurboLandingFromGalleryByName(turboLandingInfoWeb.getName());
                config.getDriver().switchTo().defaultContent();
            }
        }
    }

    public TurboLandingInfoWeb getSelectedTurboLanding() {
        WebElement selectedTurboLanding = config.getDriver().findElement(By.xpath(
                ".//div[contains(@class, 'b-turbo-landings-selector i-bem b-turbo-landings-selector_js_inited')][@data-bem]"));

        JsonObject object = new JsonParser().parse(selectedTurboLanding.getAttribute("data-bem"))
                .getAsJsonObject()
                .getAsJsonObject("b-turbo-landings-selector")
                .getAsJsonObject("value");
        String href = object.getAsJsonPrimitive("href") != null ?
                object.getAsJsonPrimitive("href").getAsString() : null;
        return new TurboLandingInfoWeb()
                .withHref(href)
                .withId(object.getAsJsonPrimitive("id").getAsLong())
                .withName(object.getAsJsonPrimitive("name").getAsString());
    }
}
