package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.commons.VideoInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;

@FindBy(xpath = "//div[contains(@class,'popup2_visible_yes')]//div[contains(@class, 'b-video-creative-selector__chooser')]")
public class VideoBlockBEM extends ExtendedHtmlElement {

    @Name("Пункт селекта Выбрать из ранее добавленных")
    @FindBy(xpath = ".//div[contains(@class, 'b-video-creative-selector__item_name_recent')]")
    private WebElement resentVideoItem;

    @Name("Пункт селекта Редактировать текущее")
    @FindBy(xpath = ".//div[contains(@class, 'b-video-creative-selector__item_name_edit')]")
    private WebElement editVideoItem;


    private VideoConstructorPage getVideoConstructorPageBlock() {
        return VideoConstructorPage.getInstance(VideoConstructorPage.class, config);
    }

    public void fillVideo(VideoInfoWeb videoInfoWeb) {
        switch (videoInfoWeb.getVideoAdSelectType()) {
            case LOAD_GALLERY:
                changeVideo(videoInfoWeb);
                break;
            case EDIT_CURRENT:
                editVideo(videoInfoWeb);
                break;
        }
    }

    public void changeVideo(VideoInfoWeb videoInfoWeb) {
        if (videoInfoWeb != null) {
            resentVideoItem.click();
            takeScreenshot();
            getVideoConstructorPageBlock().selectVideoFromGalleryByName(videoInfoWeb.getVideoName());
            config.getDriver().switchTo().defaultContent();
        }
    }

    public void editVideo(VideoInfoWeb videoInfoWeb) {
        if (videoInfoWeb != null) {
            editVideoItem.click();
            takeScreenshot();
            getVideoConstructorPageBlock().editVideoName(videoInfoWeb.getVideoName());
            config.getDriver().switchTo().defaultContent();
        }
    }
}
