package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.TextInput;

import java.util.List;

import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isDisplayed;

public class VideoConstructorPage extends BasePageObject {

    @Name("Блоки превью видеокреативов")
    @FindBy(css = "div.video-creatives__item")
    private List<WebElement> videoPreviews;

    @Name("Блок редактирования имени креатива")
    @FindBy(css = ".canvas-editable-label__name-label")
    private WebElement videoName;

    @Name("Инпут имени креатива")
    @FindBy(css = ".creative-options__title-wrapper input")
    private TextInput videoNameInput;

    @Name("Кнопка 'Добавить выбранные'")
    @FindBy(xpath = "(.//div[contains(@class, 'video-creatives__footer canvas-footer__footer')]//button)[1]")
    private WebElement addSelectedVideo;

    @Name("Снять чекбокс 'Показывать только креативы, привязанные к объявлениям'")
    @FindBy(xpath = ".//span[contains(@class, 'video-creatives__show-checkbox')]//input")
    private CheckBoxBEM bannerLinkedCreativeCheckbox;

    @Name("preloader")
    @FindBy(css = ".preloader_progress_yes")
    private WebElement preloader;

    @Name("Кнопка 'Создать' в конструкторе креативов")
    @FindBy(css = ".add-creative-page__submit-button button")
    private WebElement createVideo;

    @Name("preloader в конструкторе при изменении полей")
    @FindBy(css = ".preloader__overlay")
    private WebElement preloader_in_constructor;

    @Name("input  с поиском по креативам")
    @FindBy(xpath = ".//div[contains(@class, 'video-creatives__input')]//input")
    private WebElement finder_in_creatives_list;



    public void editVideoName(String newName) {
        waitForElement(preloader_in_constructor, 5, not(isDisplayed()));
        videoName.click();
        videoNameInput.clear();
        videoNameInput.sendKeys(newName);
        createVideo.click();
    }

    public void selectVideoFromGalleryByName(String name) {
        waitForElement(preloader, 5, not(isDisplayed()));
        setCreativeCheckBoxState(false);
        waitForElement(preloader, 5, not(isDisplayed()));
        finder_in_creatives_list.sendKeys(name);
        waitForElement(preloader, 5, not(isDisplayed()));
        addCreativeFromGalleryByName(name);
        waitUntilRowsWillBeLoaded();
        addSelectedVideo.click();
    }


    public void setCreativeCheckBoxState(Boolean state) {
        setCheckboxState(bannerLinkedCreativeCheckbox, state);
    }


    public void waitUntilRowsWillBeLoaded() {
        waitForElement(addSelectedVideo, 10, isDisplayed());
    }


    public void addCreativeFromGalleryByName(String name) {
        chooseVideoWithName(name);

    }

    private void chooseVideoWithName(String name) {
        WebElement block = videoPreviews
                .stream()
                .filter(x -> x.findElement(By.cssSelector("div.video-creatives__item-name")).getText().equals(name))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Не найдено видео с именем " + name));
        block.click();
    }

    @Name("Имя Видео")
    @FindBy(xpath = ".//*[contains(@class, 'video-addition__name')]")
    private WebElement groupName;

    public String getGroupName() {
        return groupName.getText();
    }

}

