package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.objects.banners.commons.VideoInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;

@FindBy(xpath = "//div[contains(@class,'popup_visibility_visible')]//div[@class = 'b-image-add-loader__chooser']")
public class VideoCreativeBlockBem extends ExtendedHtmlElement {

    @Name("Пункт селекта Сконструировать по шаблону")
    @FindBy(xpath = ".//div[contains(@class, 'b-image-add-loader__chooser-item_type_cpc-video-create')]")
    private WebElement createVideoFromTemplate;

    @Name("Пункт селекта Выбрать из ранее добавленных")
    @FindBy(xpath = ".//div[contains(@class, 'b-image-add-loader__chooser-item_type_cpc-video-gallery')]")
    private WebElement loadVideoFromGallery;

    private VideoConstructorPage getVideoConstructorPageBlock() {
        return VideoConstructorPage.getInstance(VideoConstructorPage.class, config);
    }

    public void loadVideoFromGallery(VideoInfoWeb videoInfoWeb) {
        if (videoInfoWeb != null) {
            loadVideoFromGallery.click();
            takeScreenshot();
            getVideoConstructorPageBlock().selectVideoFromGalleryByName(videoInfoWeb.getVideoName());
        }
    }
}