package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.imagebanners.blocks;

import java.util.concurrent.TimeUnit;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.matchers.TypifiedElementMatchers;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;

@Name("Попап добавления ссылки на сайт в новосозданные баннеры на креативах")
@FindBy(xpath = "//div[contains(@class, 'popup_visibility_visible')]" +
        "/div[contains(@class,  'popup__content')]" +
        "[.//div[contains(@class, 'b-href-popup')]]")
public class AddHrefToCreativeBannersPopup extends ExtendedHtmlElement {

        @Name("Поле для ввода ссылки на картинку")
        @FindBy(xpath = ".//input[contains(@class,'input__control')]")
        private TextInput hrefInput;

        @Name("Кнопка отменить")
        @FindBy(xpath = ".//button[contains(@class, 'b-href-popup__cancel')]")
        private Button cancelButton;

        @Name("Кнопка 'Применить'")
        @FindBy(xpath = ".//button[contains(@class, 'b-href-popup__save')]")
        private Button saveButton;

        public void setHref(String href) {
                takeScreenshot();
                hrefInput.sendKeys(href);
                takeScreenshot();
                assumeThat("кнопка 'Сохранить' соответсвует ожиданиям", saveButton,
                        should(TypifiedElementMatchers.isEnabled()).whileWaitingUntil(timeoutHasExpired(
                                TimeUnit.SECONDS.toMillis(DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
                saveButton.click();
                takeScreenshot();
        }

        public void clickSaveButton() {
                saveButton.click();
        }
}
