package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.imagebanners.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

@Name("Блок креатива на странице создания новой группы креативов")
@FindBy(xpath = ".//div[contains(@class,'filter-list-item_type_checkbox')]")
public class CreativeFilterBlock extends ExtendedHtmlElement {

    @Name("Размер креатива")
    @FindBy(xpath = ".//div[contains(@class,'filter-list-item__name')]")
    private WebElement creativeSize;

    @Name("Чек-бокс выбора креатива")
    @FindBy(xpath = ".//span[contains(@class,'filter-list-item__checkbox')]//input")
    private CheckBoxBEM selectCreativeCheckBox;

    public String getCreativeSize() {
        return creativeSize.getText();
    }

    public void selectCreativeCheckBoxState (Boolean state) {
        setCheckboxState(selectCreativeCheckBox, state);
    }
}
