package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.imagebanners.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

@Name("Блок превью креатива на странице всех созданных креативов")
@FindBy(xpath = ".//*[@class='batches-list__item']")
public class CreativePreviewBlock extends ExtendedHtmlElement {

    @Name("Имя группы")
    @FindBy(xpath = ".//*[@class='canvas-editable-label__name-label']")
    private WebElement groupName;

    @Name("Чек-бокс выбора креатива")
    @FindBy(xpath = ".//*[@class='checkbox__box']//input")
    private CheckBoxBEM selectCreativeCheckBox;

    public String getGroupName() {
        return groupName.getText();
    }

    public void setCreativeCheckBoxState (Boolean state) {
        setCheckboxState(selectCreativeCheckBox, state);
    }
}
