package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.imagebanners.blocks;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

@Name("Попап добавления картинки в графическое объявление из уже существующих")
@FindBy(xpath = "//div[contains(@class, 'popup_visibility_visible')]" +
        "/div[contains(@class,  'popup__content')]" +
        "[.//div[contains(@class, 'b-gallery-file-chooser')]]")
public class LoadImageFromGalleryPopup extends ExtendedHtmlElement {

    @Name("Кнопка загрузить")
    @FindBy(xpath = ".//button[contains(@class, 'b-gallery-file-chooser__submit')]")
    private Button saveButton;

    @Name("Кнопка отменить")
    @FindBy(xpath = ".//button[contains(@class, 'b-gallery-file-chooser__cancel')]")
    private Button cancelButton;

    @Name("Список изображений галереи")
    @FindBy(xpath = ".//img[contains(@class , 'b-gallery-file-chooser__list-item-img')]")
    private List<WebElement> gallery;

    private WebElement getElementFromGalleryByHash(String hash) {
        for (WebElement element : gallery) {
            if (element.getAttribute("src").contains(hash)) {
                return element;
            }
        }
        throw new DirectWebError("Изображение не найдено");
    }

    public void loadGalleryImage(String imgHash) {
        takeScreenshot();
        WebElement element = getElementFromGalleryByHash(imgHash);
        if (element != null) {
            element.click();
            takeScreenshot();
            saveButton.click();
        }
        takeScreenshot();
    }
}
