package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.imagebanners.blocks;

import java.util.concurrent.TimeUnit;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.matchers.TypifiedElementMatchers;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;

@Name("Попап добавления картинки в графическое объявление через интернет")
@FindBy(xpath = "//div[contains(@class, 'popup_visibility_visible')]" +
        "/div[contains(@class,  'popup__content')]" +
        "[.//div[contains(@class, 'b-external-file-uploader')]]")
public class LoadImageFromInternetPopup extends ExtendedHtmlElement {

    @Name("Поле для ввода ссылки на картинку")
    @FindBy(xpath = ".//input[contains(@class,'input__control')]")
    private TextInput imageUrl;

    @Name("Кнопка отменить")
    @FindBy(xpath = ".//button[contains(@class, 'b-external-file-uploader__cancel')]")
    private Button cancelButton;

    @Name("Кнопка загрузить")
    @FindBy(xpath = ".//button[contains(@class, 'b-external-file-uploader__submit')]")
    private Button saveButton;

    public void loadImageFromInternet(String imgUrl) {
        takeScreenshot();
        imageUrl.sendKeys(imgUrl);
        takeScreenshot();
        assumeThat("кнопка 'сохранить не соответсвует ожиданиям'", saveButton,
                should(TypifiedElementMatchers.isEnabled()).whileWaitingUntil(timeoutHasExpired(
                        TimeUnit.SECONDS.toMillis(DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
        saveButton.click();
        takeScreenshot();
    }
}
