package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.peformance;

import java.util.List;
import java.util.function.Predicate;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;

/**
 * Created by aleran on 25.11.2015.
 */
@FindBy(xpath = "//div[contains(@class,'creatives-choose ')]")
public class CreativeBlock extends ExtendedHtmlElement {

    @Name("Строка поиска креатива")
    @FindBy(xpath = ".//div[contains(@class, 'b-creative-list-filters__search')]//input")
    private TextInput searchCreative;

    @Name("Кнопка применить (поиск)")
    @FindBy(xpath = ".//button[contains(@class, 'b-creative-list-filters__apply-btn')]")
    private Button applySearch;

    @Name("Переключатель группы/список")
    @FindBy(xpath = ".//div[contains(@class, 'b-switcher-group-list-view')]//input")
    private RadioBEM creativeViewMode;

    @Name("Выбрать креативы")
    @FindBy(xpath = ".//span[contains(@class, 'creative-list__item-selector')]//input")
    private List<CheckBoxBEM> creativeCheckBoxList;

    @Name("Выбрать креатив")
    @FindBy(xpath = ".//input[@type ='radio']")
    private RadioBEM creativeRadio;

    @Name("Отменить выбор креативов")
    @FindBy(xpath = ".//button[contains(@class,'creatives-choose__cancel')]")
    private Button cancelButton;

    @Name("Сохранить креативы")
    @FindBy(xpath = ".//button[contains(@class,'creatives-choose__save')]")
    private Button saveButton;

    @Name("Элемент ожидания ответа от сервера поиска креативов (паранжа)")
    @FindBy(xpath = "//div[@class = 'creative-list__paranja']")
    private WebElement paranjaWebElement;

    public void clickSaveCreative() {
        saveButton.click();
    }

    public void clickCancelButton() {
        cancelButton.click();
    }

    public void searchCreative(Long creativeId) {
        waitForElement(paranjaWebElement, 60, not(WebElementMatchers.isDisplayed()));
        searchCreative.clear();
        searchCreative.sendKeys(String.valueOf(creativeId));
        applySearch.click();
        waitForElement(paranjaWebElement, 60, not(WebElementMatchers.isDisplayed()));
    }

    public void selectGroupViewMode() {
        creativeViewMode.selectByValue("group");
    }

    public void selectListViewMode() {
        creativeViewMode.selectByValue("list");
    }


    public void selectNewCreative(Long creativeId) {
        selectListViewMode();
        searchCreative(creativeId);
        Predicate<CheckBoxBEM> isSearchedCreative = t -> t.getWrappedElement()
                .findElement(By.xpath("./../.."))
                .getAttribute("data-bem").contains("\"creative_id\":\"" + creativeId + "\"");

        CheckBoxBEM creativeCheckBox = creativeCheckBoxList.stream()
                .filter(isSearchedCreative)
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Креатив для добавление не найден"));
        creativeCheckBox.select();
        takeScreenshot();
        waitForElement(saveButton.getWrappedElement(), 2, WebElementMatchers.isEnabled());
        clickSaveCreative();
    }

    public void editCreative(Long creativeId) {
        searchCreative(creativeId);
        creativeRadio.selectByValue(creativeId.toString());
        takeScreenshot();
        clickSaveCreative();
    }
}
