package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.peformance;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.CreativeWeb;
import ru.yandex.autotests.direct.web.objects.banners.PerformanceBannerWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * Created by aleran on 24.11.2015.
 */
@FindBy(xpath = ".//div[contains(@class, 'b-edit-banner2 ')]")
public class PerformanceBannerBlock extends ExtendedHtmlElement {

    //region Fields
    @Name("id баннера")
    @FindBy(xpath = ".//div[contains(@class, 'field-value_name_banner-id')]")
    private WebElement bannerId;

    @Name("id креатива")
    @FindBy(xpath = ".//div[contains(@class, 'field-value_name_id')]")
    private WebElement creativeId;

    @Name("Заголовок креатива")
    @FindBy(xpath = ".//div[contains(@class, 'field-value_name_title')]")
    private WebElement creativeName;

    @Name("Размер логотипа")
    @FindBy(xpath = ".//div[contains(@class, 'creative__media-size')]")
    private WebElement creativeSize;

    @Name("Ссылка на логотип")
    @FindBy(xpath = ".//img[contains(@class, 'creative__media')]")
    private WebElement creativeUrl;

    @Name("Редактировать баннер")
    @FindBy(xpath = ".//button[contains(@class, 'edit-button')]")
    private Button editBanner;

    @Name("Удалить баннер")
    @FindBy(xpath = ".//button[contains(@class, 'remove-button')]")
    private Button removeBanner;
    //endregion

    public String getCreativeId() {
        return creativeId.getText();
    }

    public String getCreativeName() {
        return creativeName.getText();
    }

    public String getHeight() {
        return creativeSize.getText().split("x")[0];
    }

    public String getWidth() {
        return creativeSize.getText().split("x")[1];
    }

    public String getLogoURL() {
        return creativeUrl.getAttribute("src");
    }

    public Long getBannerId() {
        return Long.parseLong(bannerId.getText());
    }

    public void clickEditButton() {
        editBanner.click();
    }

    public void clickRemoveButton() {
        removeBanner.click();
    }

    public CreativeWeb getCreativeFieldsAccording(CreativeWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(CreativeWeb.class)
                .set("creativeId", this, on(PerformanceBannerBlock.class).getCreativeId())
                .set("name", this, on(PerformanceBannerBlock.class).getCreativeName())
                .set("logoURL", this, on(PerformanceBannerBlock.class).getLogoURL())
                .set("height", this, on(PerformanceBannerBlock.class).getHeight())
                .set("width", this, on(PerformanceBannerBlock.class).getWidth())
                .getActualBean();
    }

    public PerformanceBannerWeb getFormFieldsAccording(PerformanceBannerWeb expectedBean) {
        PerformanceBannerWeb bannerInfo = new PerformanceBannerWeb();
        bannerInfo.setBannerId(expectedBean.getBannerId());
        bannerInfo.setAdGroupId(expectedBean.getAdGroupId());
        bannerInfo.setCreative(getCreativeFieldsAccording(expectedBean.getCreative()));
        return bannerInfo;
    }

    public void checkParameters(BeanDifferMatcher<PerformanceBannerWeb> matcher) {
        PerformanceBannerWeb expectedBean = matcher.getExpectedBean();
        assertThat("неверные параметры ДМО Баннера", getFormFieldsAccording(expectedBean), matcher);
    }
}
