package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.turbolandigs;

import java.util.List;
import java.util.function.Predicate;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.commons.InterestInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static com.google.common.collect.Iterables.getLast;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static ru.yandex.autotests.direct.web.util.StringHelper.getNumericDataFromText;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Name("Попап с выбором типа открытия конструктора турбостраниц: короткий, товарный, пустой, библиотека")
@FindBy(xpath = "//div[contains(@class, 'b-turbo-landings-selector__templates-popup')]")
public class ChooseTurbolandingsModePopup extends ExtendedHtmlElement {

    @Name("Шаблон: короткий")
    @FindBy(xpath = ".//img[contains(@src, 'shablon_short.png')]")
    private WebElement shablonShort;

    @Name("Шаблон: товарный")
    @FindBy(xpath = ".//img[contains(@src, 'shablon_tovar.png')]")
    private WebElement shablonTovar;

    @Name("Шаблон: пустой")
    @FindBy(xpath = ".//img[contains(@src, 'shablon_empty.png')]")
    private WebElement shablonEmpty;

    @Name("Библиотека лендингов")
    @FindBy(xpath = ".//div[contains(@class, 'b-turbo-landings-selector__turbolanding-template_js_inited')][4]//button")
    private WebElement library;

    public WebElement getLibraryIcon() {
        return library;
    }
    public void chooseFromGallery() {
        library.click();
    }
}
