package ru.yandex.autotests.direct.web.pages.banners.blocks.phrases;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.data.banners.PhrasePriority;
import ru.yandex.autotests.direct.web.data.banners.PhraseTypes;
import ru.yandex.autotests.direct.web.data.priceconstructor.BannerPhrasePlatform;
import ru.yandex.autotests.direct.web.data.priceconstructor.BannerPhraseState;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.NumericInput;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.exists;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(xpath = ".//tr[contains(@class, 'b-phrases-list__phrase')]")
public class BannerPhraseRowBlock extends ExtendedHtmlElement {
    @Name("Ввод значения цены на поиске")
    @FindBy(css = "input.b-edit-phrase-price__price")
    protected NumericInput searchPriceInput;

    @Name("Ввод значения цены на поиске")
    @FindBy(css = "input.b-edit-phrase-price__price-context")
    protected NumericInput contextPriceInput;

    @Name("Текст фразы")
    @FindBy(css = "em.b-phrases-list__text-c")
    protected WebElement phraseText;

    @Name("Тект корректировки фразы")
    @FindBy(css = "span.b-phrases-list-phrase__fixation_mode_on")
    public WebElement phraseTextCorrection;

    @Name("Чекбокс для выбора фразы")
    @FindBy(css = "input.b-form-checkbox__checkbox")
    protected CheckBox phraseCheckBox;

    @Name("Цена входа в гарантию")
    @FindBy(xpath = ".//*[contains(@class, 'phrase__min') and not(contains(@class,'place-info'))]//*")
    protected WebElement priceGuaranty;

    @Name("Цена первого места в гарантии")
    @FindBy(xpath = ".//*[contains(@class, 'phrase__max') and not(contains(@class,'place-info'))]//*")
    protected WebElement priceGuarantyFirst;

    @Name("Цена спецразмещения")
    @FindBy(xpath = ".//*[contains(@class, 'phrase__pmin') and not(contains(@class,'place-info'))]//*")
    protected WebElement priceSpecialPlace;

    @Name("Цена первого места в спецразмещении")
    @FindBy(xpath = ".//*[contains(@class, 'phrase__pmax')and not(contains(@class,'place-info'))]//*")
    protected WebElement priceSpecialPlaceFirst;

    @Name("Цена клика на поиске")
    @FindBy(css = "span.b-phrases-list-phrase__search-price")
    protected WebElement priceOnSearch;

    @Name("Охват аудитории")
    @FindBy(xpath = ".//span[@class = 'b-phrases-list-phrase__coverage']")
    protected WebElement coverage;

    @Name("Автоброкер")
    @FindBy(xpath = ".//input[@class='b-edit-phrase-autobroker__autobroker']")
    public WebElement autoBroker;

    @Name("Приоритет")
    @FindBy(css = "span.b-edit-phrase-price__autobudget-link")
    protected WebElement priority;

    @Name("Выбранный приоритет")
    @FindBy(css = "input.b-edit-phrase-price__autobudgetPriority")
    protected WebElement selectedPriority;

    @Name("Прогноз траффика")
    @FindBy(css = ".b-group-phrase__current-traffic-volume")
    protected WebElement trafficForecast;

    protected PriorityPopup priorityPopup;

    //TODO перенести в бранч campaign-bem
    @Name("Блок в котором отображается текст 'Клиент не согласен'")
    @FindBy(css = "span.decline_phrase")
    private WebElement declinePhraseText;

    @Name("Ссылка для открытия попапа минус слов")
    @FindBy(xpath = ".//span[contains(@class, 'b-phrase-minus-words__minus-switcher')]")
    private WebElement openMinusKeyWordsPopup;

    @Name("Родительская таблица")
    @FindBy(xpath = "./ancestor::tbody[contains(@class, 'b-phrases-list-group')]")
    private WebElement parentTable;

    public static class MinusKeywordsPopup extends HtmlElement {

        @Name("Кнопка закрытия попапа")
        @FindBy(xpath = "//i[contains(@class, 'b-phrase-minus-words-popup__close')]")
        private WebElement closeButton;

    }

    @Name("Попап минус слов")
    @FindBy(xpath = "//div[contains(@class, 'b-phrase-minus-words-popup__content')]")
    private MinusKeywordsPopup minusKeyWordPopup;

    @FindBy(xpath = "//div[contains(@class, 'b-popupa_type_autobudget')]")
    public static class PriorityPopup extends HtmlElement {
        @FindBy(xpath = ".//span[@class = 'b-form-radio__inner']")
        protected List<WebElement> priorities;

        protected void clickPriority(String value) {
            for (WebElement priority : priorities) {
                WebElement input = priority.findElement(By.xpath(".//input"));
                if (value.equals(input.getAttribute("value"))) {
                    priority.click();
                }
            }
        }
    }

    protected String getPhraseID() {
        Pattern pattern = Pattern.compile("phrase:\\d+");
        Matcher matcher = pattern.matcher(this.getAttribute("onclick"));
        if (matcher.find()) {
            return matcher.group().replace("phrase:", "");
        } else {
            return null;
        }
    }

    protected String getCategoryID() {
        Pattern pattern = Pattern.compile("category:\\d+");
        Matcher matcher = pattern.matcher(this.getAttribute("onclick"));
        if (matcher.find()) {
            return matcher.group().replace("category:", "");
        } else {
            return null;
        }
    }

    protected String getRetargetingID() {
        Pattern pattern = Pattern.compile("retargeting:\\d+");
        Matcher matcher = pattern.matcher(this.getAttribute("onclick"));
        if (matcher.find()) {
            return matcher.group().replace("retargeting:", "");
        } else {
            return null;
        }
    }

    protected PhraseTypes getPhraseType() {
        if (getPhraseID() != null)
            return PhraseTypes.PHRASE;
        if (getRetargetingID() != null)
            return PhraseTypes.RETARGETING;
        return null;
    }

    public Long getBannerId() {
        Pattern pattern = Pattern.compile("banner:\\d+");
        Matcher matcher = pattern.matcher(this.getAttribute("onclick"));
        if (matcher.find()) {
            return Long.valueOf(matcher.group().replace("banner:", ""));
        } else {
            return null;
        }
    }

    /**
     * @return Текст фразы
     */
    protected String getPhraseText() {
        return this.phraseText.getText().replace("+", "").trim();
    }

    /**
     * имеет вид Рубрика: Авто / Продажа автомобилей / Российские авто / УАЗ
     *
     * @return полное название рубрики
     */
    protected String getRubricText() {
        Pattern pattern = Pattern.compile(":.*"); //все что после двоеточия
        Matcher matcher = pattern.matcher(this.phraseText.getAttribute("textContent").replaceAll(" +\n +", ""));
        if (matcher.find()) {
            return matcher.group().replace(":", "").replaceAll(" / ", "/").trim();
        } else {
            return "";
        }
    }

    /**
     * имеет вид Условие: "Retargeting" (ретаргетинг)
     *
     * @return текст условия ретаргетинга
     */
    protected String getRetargetingName() {
        Pattern pattern = Pattern.compile("\".*\""); // все что между ковычками
        Matcher matcher = pattern.matcher(this.phraseText.getAttribute("textContent"));
        if (matcher.find()) {
            return matcher.group().replaceAll("^\"|\"$", ""); // удаляется первая и последняя ковычки
        } else {
            return "";
        }
    }

    public String getContextPrice() {
        return contextPriceInput.getValue();
    }

    public String getSearchPrice() {
        return searchPriceInput.getValue();
    }

    public String getPriorityValue() {
        return selectedPriority.getAttribute("value");
    }

    public String getPriceGuaranty() {
        return priceGuaranty.getText();
    }

    public String getPriceGuarantyFirst() {
        return priceGuarantyFirst.getText();
    }

    public String getPriceSpecialPlace() {
        return priceSpecialPlace.getText();
    }

    public String getPriceSpecialPlaceFirst() {
        return priceSpecialPlaceFirst.getText();
    }

    public String getPriceOnSearch() {
        return priceOnSearch.getText();
    }

    public String getTrafficForecast() {
        return trafficForecast.getText();
    }

    public Boolean isRubric() {
        PhraseTypes type = getPhraseType();
        return type != null && type == PhraseTypes.RUBRIC;
    }

    public void fillContextPrice(Float price) {
        fillContextPrice(String.valueOf(price));
    }

    public void fillContextPrice(String price) {
        if (price == null)
            return;
        new WebElementsActions(config).setNumericValue(contextPriceInput, price);
    }

    public void fillSearchPrice(Float price) {
        if (price == null)
            return;
        new WebElementsActions(config).setNumericValue(searchPriceInput, price);
    }

    public void selectPriority(String priorityApiText) {
        if (priority == null)
            return;
        PhrasePriority priority = PhrasePriority.getPhrasePriorityByValue(priorityApiText);
        if (!selectedPriority.getAttribute("value").equals(priority.getPriorityValue())) {
            this.priority.click();
            priorityPopup.clickPriority(priority.getPriorityValue());
        }
    }

    /**
     * @return Возвращает название фразы/рубрики/названия ретаргетинга
     */
    public String getPhrase() {
        PhraseTypes phraseType = getPhraseType();
        if (phraseType == null)
            return "";
        switch (phraseType) {
            case PHRASE:
                return getPhraseText().replace("+", "");
            case RETARGETING:
                return getRetargetingName();
            default:
                return "";
        }
    }

    private String getParentTableOnClick() {
        return parentTable.getAttribute("onClick");
    }

    public Boolean isDeclined() {
        return getParentTableOnClick().contains("declined");
    }

    public Boolean isLowCTR() {
        return getParentTableOnClick().contains("low_ctr");
    }

    public Boolean isSwitchedOffOnSearch() {
        return getParentTableOnClick().contains("context");
    }

    public Boolean isActive() {
        return getParentTableOnClick().contains("active");
    }

    public String getState() {
        if (isDeclined()) {
            return BannerPhraseState.DECLINED.toString();
        } else if (isLowCTR()) {
            return BannerPhraseState.LOW_CTR.toString();
        } else if (isSwitchedOffOnSearch()) {
            return BannerPhraseState.SWITCHED_OFF_ON_SEARCH.toString();
        } else if (isActive()) {
            return BannerPhraseState.ACTIVE.toString();
        }
        return null;
    }

    public void selectPhrase() {
        phraseCheckBox.select();
    }

    public void deselectPhrase() {
        phraseCheckBox.deselect();
    }

    public void checkPhraseMinusKeyWordPopupText(org.hamcrest.Matcher matcher) {
        openMinusKeyWordsPopup.click();
        takeScreenshot();
        assertThat("текст в попапе минус слов не соответствует ожиданиям",
                minusKeyWordPopup.getText(), matcher);
        minusKeyWordPopup.closeButton.click();
    }

    public void checkClientDecline() {
        assertThat("не отображается информация о том что клиент не согласен с фразой",
                declinePhraseText, exists());
    }

    public void checkPrice(BannerPhraseInfoWeb expectedBean, BannerPhrasePlatform platform,
                           org.hamcrest.Matcher<WrapsElement> matcher) {
        NumericInput price = platform == BannerPhrasePlatform.CONTEXT ? contextPriceInput : searchPriceInput;
        assertThat("поле ввода цены для фразы " + expectedBean.getPhrase() + " не прошло проверку",
                price, matcher);
    }
}
