package ru.yandex.autotests.direct.web.pages.banners.blocks.phrases;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * Блок превью баннера на странице кампании и редактирования ставок баннера
 *
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(css = "div.b-banner-list__layout__frame")
public class BannerPreviewBlock extends HtmlElement {
    @Name("id баннера")
    @FindBy(xpath = ".//a[@name]")
    private WebElement bannerID;

    @Name("Заголовок с номером баннера")
    @FindBy(css = "div.b-banner-list__layout__header")
    private WebElement bannerIDHeader;

    public Long getBannerId() {
        return Long.parseLong(bannerID.getAttribute("name"));
    }

    public String getBannerIdHeader() {
        return bannerIDHeader.getText();
    }
}
