package ru.yandex.autotests.direct.web.pages.banners.blocks.phrases;

import java.util.ArrayList;
import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;

/**
 * Created with IntelliJ IDEA.
 * User: shmykov
 * Блок уточнения фразы.
 * Присутствует на 2м шаге редактирования баннера и на странице кампании.
 */
@FindBy(css = "div.b-phrase-popup__adjust-block")
public class PhraseRefineBlock extends ExtendedHtmlElement {

    //region Fields
    @Name("Прогнозируемое число показов")
    @FindBy(css = "span.b-phrase-adjustment__forecast-num")
    private WebElement forecastNum;

    @Name("Минус слова")
    @FindBy(css = "div.b-phrase-adjustment__minus-word")
    private List<WebElement> minusWords;
    //endregion

    //region Field getters
    public Integer getForecastNum() {
        waitForElement(forecastNum,
                (int) DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec(),
                WebElementMatchers.isDisplayed());
        return Integer.parseInt(forecastNum.getText());
    }

    public List<String> getMinusWordsList() {
        List<String> minusWordsText = new ArrayList<>();
        for (WebElement minusWord : minusWords) {
            minusWordsText.add(minusWord.getText().substring(1));
        }
        return minusWordsText;
    }
    //endregion
}