package ru.yandex.autotests.direct.web.pages.campaigns;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.google.common.primitives.Ints;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.data.AttributionModelEnum;
import ru.yandex.autotests.direct.web.data.RadioInputMethod;
import ru.yandex.autotests.direct.web.data.textresources.EditCampaignResource;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.HierarchicalMultipliersWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.ContactInfoWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.CampaignInfoWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.RelevantPhrasesInfo;
import ru.yandex.autotests.direct.web.objects.campaigns.parameters.CampaignContextStrategyWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.parameters.CampaignStrategyWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.parameters.EmailNotificationInfoWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.parameters.SmsNotificationInfoWeb;
import ru.yandex.autotests.direct.web.pages.adjustment.blocks.AdjustmentRatesPopupBlock;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.AddressAndPhoneBlockBEM;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.MobileAppSelect;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem.ContextParametersPopupBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem.DisabledDomainsPopupBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem.DisabledIPsPopupBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem.EmailNotificationsPopupBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem.KeyGoalsPopupBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem.MetrikaCountersPopupBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem.MinusKeyWordsPopupBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem.RelevantPhrasesPopupBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem.SmsNotificationsPopupBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.strategy.IStrategyBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.strategy.IStrategyBlockProvider;
import ru.yandex.autotests.direct.web.pages.campaigns.timetarget.TimeTargetPopupBlock;
import ru.yandex.autotests.direct.web.pages.regionselectpopup.GeoCorrectionWeb;
import ru.yandex.autotests.direct.web.pages.regionselectpopup.GeoCorrectionsPopupBlock;
import ru.yandex.autotests.direct.web.pages.regionselectpopup.RegionSelectPopupBlockBEM;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy.StrategiesEnum;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy.StrategyBemBlock;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy.StrategyBlock;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy.StrategyWeb;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.CalendarInputBEM;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBlockBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TumblerBEM;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ch.lambdaj.Lambda.on;
import static java.lang.Integer.parseInt;
import static java.util.Objects.isNull;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.EDIT_CAMP;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.EDIT_CAMP_FOR_LOGIN;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.NEW_CAMP;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.NEW_CAMP_FOR_LOGIN;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.NEW_CAMP_TYPE;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.NEW_CAMP_TYPE_FOR_LOGIN;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.NEW_DYNAMIC_CAMP_FOR_LOGIN;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.NEW_MC_BANNER_CAMP_FOR_LOGIN;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.NEW_PERFOMANCE_CAMP_FOR_LOGIN;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.SHOW_CAMP_SETTINGS;
import static ru.yandex.autotests.direct.web.steps.BackendSteps.toBoolean;
import static ru.yandex.autotests.direct.web.steps.BackendSteps.toDirectApiBooleanString;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillRadio;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isDisplayed;
import static ru.yandex.qatools.htmlelements.matchers.WrapsElementMatchers.exists;

@NamedUrls({
        @NamedUrl(name = EDIT_CAMP, url = "/registered/main.pl?cmd=editCamp&cid={1}"),
        @NamedUrl(name = EDIT_CAMP_FOR_LOGIN, url = "/registered/main.pl?cmd=editCamp&cid={1}&ulogin={2}"),
        @NamedUrl(name = NEW_CAMP_FOR_LOGIN, url = "/registered/main.pl?cmd=editCamp&new_camp=1&ulogin={1}"),
        @NamedUrl(name = NEW_CAMP_TYPE_FOR_LOGIN, url = "/registered/main.pl?cmd=editCamp&new_camp=1&ulogin={1}&mediaType={2}"),
        @NamedUrl(name = NEW_CAMP, url = "/registered/main.pl?cmd=editCamp&new_camp=1"),
        @NamedUrl(name = NEW_CAMP_TYPE, url = "/registered/main.pl?cmd=editCamp&new_camp=1&mediaType={1}"),
        @NamedUrl(name = NEW_DYNAMIC_CAMP_FOR_LOGIN, url = "/registered/main.pl?cmd=editCamp&new_camp=1&mediaType=dynamic&ulogin={1}"),
        @NamedUrl(name = NEW_PERFOMANCE_CAMP_FOR_LOGIN, url = "/registered/main.pl?cmd=editCamp&new_camp=1&mediaType=performance&ulogin={1}"),
        @NamedUrl(name = SHOW_CAMP_SETTINGS, url = "/registered/main.pl?cmd=showCampSettings&cid={1}&ulogin={2}"),
        @NamedUrl(name = NEW_MC_BANNER_CAMP_FOR_LOGIN, url = "/registered/main.pl?cmd=editCamp&new_camp=1&mediaType=mcbanner&ulogin={1}")
})
public class EditCampPage extends BasePageObject implements IStrategyBlockProvider {

    @Name("Кнопка открытия попапа изменения стратегии на странице редактирования кампании")
    @FindBy(xpath = ".//button[contains(@class,'strategy') and contains(@class,'switcher')]")
    public Button changeStrategyButton;

    @Name("Тип кампании")
    @FindBy(xpath = ".//div[contains(@class, 'b-choose-campaign-type__title')]")
    private WebElement campaignType;

    @Name("Название кампании")
    @FindBy(xpath = ".//input[@name='name']")
    private TextInput name;

    @Name("Дата начала кампании")
    @FindBy(css = "div.b-campaign-period__start")
    private CalendarInputBEM startDate;

    @Name("Дата окончания кампании")
    @FindBy(css = "div.b-campaign-period__finish")
    private CalendarInputBEM endDate;

    @Name("Кнопка 'Сбросить дату окончания'")
    @FindBy(css = "span.b-campaign-period__remove i")
    private Button resetEndDateButton;

    @Name("Кнопка добавления даты окончания")
    @FindBy(css = "span.b-campaign-period__plus")
    private Button addEndDateButton;

    @Name("Кнопка Изменить настройки уведомлений")
    @FindBy(css = "button.b-campaign-email-notifications-adapter__opener")
    private Button changeEmailNotifications;

    private EmailNotificationsPopupBlock emailNotificationsPopupBlock;

    @Name("Кнопка настроить SMS-уведомления")
    @FindBy(css = "div.b-campaign-settings__sms-control button")
    private Button changeSmsNotifications;

    private SmsNotificationsPopupBlock smsNotificationsPopupBlock;

    @Name("Параметры текущей стратегии")
    @FindBy(css = "div.b-campaign-strategy2__strategy-hint")
    private WebElement strategyParameters;

    @Name("Кнопка настройки временного таргетинга")
    @FindBy(xpath = ".//div[contains(@class, 'b-time-targeting-presenter')]/descendant::button")
    private Button changeTimeTargetButton;

    @Name("Временной таргетинг")
    @FindBy(css = "div.b-time-targeting-presenter__text-value")
    private WebElement timeTargetParameters;

    private TimeTargetPopupBlock timeTargetPopupBlock;

    @Name("Кнопка Изменения единого региона показа")
    @FindBy(css = "div.b-regions-selector button")
    private Button changeRegionButton;

    @Name("Значение единого региона показа")
    @FindBy(css = "div.b-regions-selector__selected-regions")
    private WebElement regions;

    @Name("Блок для нахождения id выбранных регионов")
    @FindBy(css = "div.b-regions-selector")
    private WebElement regionIDs;

    private RegionSelectPopupBlockBEM regionSelectPopupBlock;

    @Name("Использовать единый адрес и телефон")
    @FindBy(xpath = ".//div[contains(@class, 'b-vcard-control__tumbler-wrapper')]//input")
    private TumblerBEM useAddressAndPhone;

    private AddressAndPhoneBlockBEM addressAndPhone;

    @Name("Задать единые минус слова")
    @FindBy(css = "div.b-minus-words-control__switcher button")
    private Button setMinusKeywordsButton;

    @Name("Минус слова")
    @FindBy(css = "input.b-minus-words-control__minus-words-hidden")
    private WebElement minusKeywords;

    private MinusKeyWordsPopupBlock minusKeyWordsPopupBlock;

    @Name("Настройки в сетях")
    @FindBy(css = "div.b-campaign-settings__context-limit-text")
    private WebElement contextStrategyParameters;

    private ContextParametersPopupBlock contextParametersPopupBlock;

    @Name("Кнопка изменения настроек дополнительных релевантных фраз")
    @FindBy(css = "div.b-campaign-broadmatch-adapter button")
    private Button changeAdditionalRelevantPhrases;

    private RelevantPhrasesPopupBlock relevantPhrasesPopupBlock;

    @Name("Специальные настройки")
    @FindBy(css = "div.b-campaign-settings__expander div")
    private WebElement extendedProperties;

    @Name("Кнопка Задать запрещенные площадки")
    @FindBy(xpath = "(.//div[contains(@class, 'b-campaign-settings__item_of_dont-show')]//button)[1]")
    private Button setDisabledDomainsButton;

    @Name("Запрещенные площадки")
    @FindBy(xpath = ".//div[@class='b-campaign-settings__dont-show-hint']")
    private WebElement disabledDomains;

    private DisabledDomainsPopupBlock disabledDomainsPopupBlock;

    @Name("кнопка Задать запрещенные ip-адреса")
    @FindBy(css = "div.b-campaign-settings__disabled-ips button")
    private Button setDisabledIPsButton;

    @Name("Запрещенные адреса")
    @FindBy(xpath = ".//div[@class='b-campaign-settings__disabled-ips']//div[contains(@data-bem, 'disabledIps')]")
    private WebElement disabledIps;

    private DisabledIPsPopupBlock disabledIPsPopupBlock;

    @Name("Отключить подстановку части текста в заголовок")
    @FindBy(xpath = ".//input[@name='no_title_substitute']")
    private CheckBoxBEM noTitleSubstitute;

    @Name("Не учитывать автоматически остановленные объявления конкурентов")
    @FindBy(xpath = ".//input[@name='fairAuction']")
    private CheckBoxBEM considerRivalsBanners;

    @Name("Разметка ссылок для метрики")
    @FindBy(xpath = ".//input[@name='status_click_track']")
    private CheckBoxBEM markLinksForMetrika;

    @Name("Останавливать объявления при неработающем сайте")
    @FindBy(xpath = ".//input[@name='statusMetricaControl']")
    private CheckBoxBEM statusMetricaControl;

    @Name("Кнопка Задать дополнительные счетчики метрики")
    @FindBy(css = "div.b-campaign-settings__metrika-counters button")
    private Button setAdditionalMetrikaCountersButton;

    @Name("Дополнительные счетчики Метрики")
    @FindBy(xpath = ".//div[contains(@class, 'b-metrika-counters-popup-adapter__metrika-counters-string')]/a")
    private List<WebElement> additionalMetrikaCounters;

    private MetrikaCountersPopupBlock metrikaCountersPopupBlock;

    @Name("Добавить кампанию в самые важные")
    @FindBy(xpath = ".//input[@name='favorite_camp']")
    private CheckBoxBEM favoriteCampaign;

    @Name("Чекбокс пустая кампания для оплаты, доступна для менеджера")
    @FindBy(xpath = ".//input[@name='payEmptyCamp']")
    private CheckBox payEmptyCamp;

    @Name("Количество объявлений на странице кампании, доступно для агенства и менеджера")
    @FindBy(xpath = ".//input[@name='banners_per_page']")
    private TextInput bannersPerPage;

    @Name("Попап стратегии")
    private StrategyBlock strategyPopup;

    // Для РМП
    @Name("Выбор типа устройств")
    @FindBy(xpath = ".//input[@name = 'device_type_targeting']")
    private RadioBEM deviceTypeTargetingRadio;

    // Для РМП
    @Name("Выбор типа связи")
    @FindBy(xpath = ".//input[@name = 'network_targeting']")
    private RadioBEM networkTargetingRadio;

    //для сервисируемого клиента
    @Name("Перевести и эту кампанию на обслуживание")
    @FindBy(xpath = ".//input[@name='servicing_request']")
    private CheckBoxBEM serviceByManagerCheckBox;

    @Name("Кнопка 'Cохранить'")
    @FindBy(css = "button.b-campaign-settings__submit")
    private Button saveButton;

    @Name("Кнопка 'Изменить' корректировки ставок")
    @FindBy(css = "div.b-adjustment-rates-popup button")
    private Button changeAdjustmentRates;

    private AdjustmentRatesPopupBlock adjustmentRatesPopupBlock;

    @Name("Чекбокс 'Расширенный географический таргетинг'")
    @FindBy(xpath = ".//*[@name='extended_geotargeting']")
    private CheckBox extendedGeotargeting;

    @Name("Кнопка 'Изменить настройки таргетинга на устройства'")
    @FindBy(xpath = ".//div[contains(@class,'b-campaign-settings__device-targeting')]//button")
    private Button setDeviceTargetingButton;

    @Name("Блок специальных настроек")
    @FindBy(xpath = ".//div[contains(@class, 'b-campaign-settings__expand')]//div[contains(@class, 'b-campaign-settings__extra')]")
    private WebElement expandedPropertiesBlock;

    @Name("Скрытое поле измененные регионы")
    @FindBy(xpath = "//input[@name='json_geo_changes']")
    private WebElement changedRegions;

    @Name("Модели атрибуции")
    @FindBy(xpath = ".//select[@name='attribution_model']")
    private SelectBEM attributionModelSelect;

    @Name("Кнопка 'Ключевые цели'")
    @FindBy(css = "button.b-metrics-key-goals__opener")
    private Button keyGoalsButton;

    private KeyGoalsPopupBlock keyGoalsPopup;

    //New RMP

    @Name("Открытие дополнительных настроек кампании")
    @FindBy(xpath = ".//div[contains(@class, 'b-campaign-settings__expander')]//i")
    private WebElement additionalSettingsButton;

    @Name("Блок расширенных настроек")
    @FindBy(css = "div.b-campaign-settings__extra")
    private WebElement additionalSettingsBlock;

    @Name("Селект Приложение")
    private MobileAppSelect appSelect;

    @Name("Радиопереключатель 'Цель рекламной кампании'")
    @FindBy(xpath = "//input[@name='mobile_app_goal']")
    private RadioBlockBEM campaignGoal;

    @Name("Имя приложения")
    @FindBy(css = ".b-mobile-app-item__app-info")
    private WebElement appName;

    private GeoCorrectionsPopupBlock geoCorrectionsPopupBlock;

    private void fillGeoCorrection(GeoCorrectionWeb info) {
        regionSelectPopupBlock.openRegionCorrectionPopup(info.getRegionId());
        geoCorrectionsPopupBlock.fillCorrection(info);
    }

    public void fillGeoCorrection(List<GeoCorrectionWeb> corrections) {
        if (corrections == null) {
            return;
        }
        clickOpenRegion();
        setTumblerGeoCorrections(true);
        regionSelectPopupBlock.clearAllGeoCorrections();
        corrections.forEach(this::fillGeoCorrection);
        clickSaveInRegionPopup();
    }

    public void clickSaveInRegionPopup() {
        regionSelectPopupBlock.clickOnSaveButton();
    }

    private AddressAndPhoneBlockBEM getAddressAndPhoneBlock() {
        addressAndPhone.setConfig(config);
        return addressAndPhone;
    }

    public AlertSteps alert() {
        return AlertSteps.getInstance(AlertSteps.class, config);
    }

    private ContextParametersPopupBlock getContextParametersPopupBlock() {
        contextParametersPopupBlock.setConfig(config);
        return contextParametersPopupBlock;
    }

    private DisabledDomainsPopupBlock getDisabledDomainsPopupBlock() {
        disabledDomainsPopupBlock.setConfig(config);
        return disabledDomainsPopupBlock;
    }

    private DisabledIPsPopupBlock getDisabledIPsPopupBlock() {
        disabledIPsPopupBlock.setConfig(config);
        return disabledIPsPopupBlock;
    }

    public EmailNotificationsPopupBlock getEmailNotificationsPopupBlock() {
        emailNotificationsPopupBlock.setConfig(config);
        return emailNotificationsPopupBlock;
    }

    private MinusKeyWordsPopupBlock getMinusKeyWordsPopupBlock() {
        minusKeyWordsPopupBlock.setConfig(config);
        return minusKeyWordsPopupBlock;
    }

    public AttributionModelEnum getAttributionModel() {
        return AttributionModelEnum.getByTextValue(attributionModelSelect.getSelectedValue());
    }

    public void openExtendedProperties() {
        if (!expandedPropertiesBlock.isDisplayed()) {
            extendedProperties.click();
        }
    }

    private void fillCampaignName(String campaignName) {
        if (isNull(campaignName)) {
            return;
        }
        fillTextInput(name, campaignName);
    }

    private void fillStrategy(CampaignStrategyWeb campaignStrategy, CampaignContextStrategyWeb contextStrategy) {
        if (campaignStrategy == null && contextStrategy == null) {
        }
    }

    /**
     * Устанавливает дату начала и окончания кампании
     * Если начало кампании null, ничего не устанавливается
     * Для очистки даты требуется передать дату 1 января 1995г
     *
     * @param startDate
     * @param endDate
     */
    private void inputDates(Date startDate, Date endDate) {
        if (startDate == null) {
            return;
        }

        this.startDate.fillDate(startDate);

        if (endDate == null) {
            return;
        }

        if (this.addEndDateButton.isDisplayed()) {
            this.addEndDateButton.click();
        }
        this.endDate.fillDate(endDate);
    }

    private void fillNotifications(EmailNotificationInfoWeb info) {
        if (info == null) {
            return;
        }
        this.changeEmailNotifications.click();
        getEmailNotificationsPopupBlock().fillParameters(info);
    }

    private void fillSmsNotifications(SmsNotificationInfoWeb info) {
        if (info == null) {
            return;
        }
        sleep(1000);
        this.changeSmsNotifications.click();
        this.smsNotificationsPopupBlock.fillParameters(info);
    }

    private void fillAdditionalRelevantPhrases(RelevantPhrasesInfo info) {
        if (info == null) {
            return;
        }
        openExtendedProperties();
        this.changeAdditionalRelevantPhrases.click();
        this.relevantPhrasesPopupBlock.fillParameters(info);
    }

    public void fillRegions(String geo, boolean cleanExistingRegions) {
        if (geo == null) {
            return;
        }
        changeRegionButton.click();
        if (cleanExistingRegions) {
            regionSelectPopupBlock.clearAllRegions();
            AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
        }
        regionSelectPopupBlock.fillRegions(geo.replaceAll(" ", ""));
        alert().acceptIfPresent(containsString(EditCampaignResource.SET_REGION_INFO_MESSAGE.toString()));
        waitForElement(regionSelectPopupBlock, 10, not(isDisplayed()));
    }

    public void setTumblerGeoCorrections(Boolean status) {
        regionSelectPopupBlock.setTumbler(status);
    }

    public void clearRegionsSaveAndWaitErrorBlock() {
        changeRegionButton.click();
        regionSelectPopupBlock.clearAllRegions();
        regionSelectPopupBlock.clickOnSaveButton();
        waitForElement(regionSelectPopupBlock.getRegionsPopupErrorsBlock(), 5, WebElementMatchers.isDisplayed());
    }

    private void fillMinusKeyWordsAndCheckPopupClosed(String[] keyWords) {
        if (keyWords == null) {
            return;
        }
        fillMinusWords(keyWords);
        assertThat("попап действий с минус-словами не закрылся при сохранении", getMinusKeyWordsPopupBlock(),
                should(not(WebElementMatchers.isDisplayed())).whileWaitingUntil(timeoutHasExpired(
                        TimeUnit.SECONDS.toMillis(DirectTestRunProperties.getInstance()
                                .getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

    public void fillMinusKeyWordsAndCheckSaveButton(String[] minusWords, Matcher<WebElement> matcher) {
        fillLongMinusKeyWordsWithoutSave(minusWords);
        getMinusKeyWordsPopupBlock().checkSaveButton(matcher);
    }

    public void fillMinusWords(String[] keyWords) {
        if (keyWords == null) {
            return;
        }
        openExtendedProperties();
        setMinusKeywordsButton.click();
        getMinusKeyWordsPopupBlock().fillParameters(keyWords);
    }

    public void fillLongMinusKeyWordsWithoutSave(String[] keyWords) {
        if (keyWords == null) {
            return;
        }
        openExtendedProperties();
        setMinusKeywordsButton.click();
        getMinusKeyWordsPopupBlock().fillLongParametersWithoutSave(keyWords);
    }

    private void fillDisabledDomains(List<String> domains) {
        if (domains == null) {
            return;
        }
        setDisabledDomainsButton.click();
        getDisabledDomainsPopupBlock().fillParameters(domains);
    }

    private void fillDisabledIPs(List<String> ips) {
        if (ips == null) {
            return;
        }
        setDisabledIPsButton.click();
        getDisabledIPsPopupBlock().fillParameters(ips);
    }

    private void fillStatusMetricaControl(String status) {
        Boolean value = toBoolean(status);
        if (value == null) {
            return;
        }
        setCheckboxState(statusMetricaControl, value);
    }

    private void fillMetricaCounters(int... counters) {
        if (counters == null) {
            return;
        }
        setAdditionalMetrikaCountersButton.click();
        metrikaCountersPopupBlock.fillParameters(counters);
        should(not(WebElementMatchers.exists()))
                .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(4))).matches(metrikaCountersPopupBlock);
    }

    private void checkEmailNotification(EmailNotificationInfoWeb info) {
        if (info == null) {
            return;
        }
        changeEmailNotifications.click();
        getEmailNotificationsPopupBlock().checkParameters(info);
        getEmailNotificationsPopupBlock().clickCancel();
    }

    private void checkSmsNotification(SmsNotificationInfoWeb info) {
        if (info == null) {
            return;
        }
        changeSmsNotifications.click();
        smsNotificationsPopupBlock.checkParameters(info);
        smsNotificationsPopupBlock.clickCancel();
    }

    private void checkAdditionalRelevantPhrases(RelevantPhrasesInfo info) {
        if (info == null) {
            return;
        }
        openExtendedProperties();
        changeAdditionalRelevantPhrases.click();
        relevantPhrasesPopupBlock.checkParameters(info);
        relevantPhrasesPopupBlock.clickCancel();
    }

    private void checkHierarchicalMultipliers(HierarchicalMultipliersWeb multipliers) {
        if (multipliers == null) {
            return;
        }
        changeAdjustmentRates.click();
        adjustmentRatesPopupBlock.checkParameters(multipliers);
        adjustmentRatesPopupBlock.clickCancel();
    }

    private void checkDisabledDomains(List<String> disabledDomains) {
        if (disabledDomains == null) {
            return;
        }
        assertThat("неверный список запрещенных площадок", getDisabledDomains(),
                hasItems(disabledDomains.toArray(new String[disabledDomains.size()])));
    }

    private void checkDisabledIps(List<String> disabledIps) {
        if (disabledIps == null) {
            return;
        }
        assertThat("неверный список запрещенных IP", getDisabledIps(),
                hasItems(disabledIps.toArray(new String[disabledIps.size()])));
    }

    private void checkMinusKeywords(String[] expectedKeywords) {
        if (expectedKeywords == null) {
            return;
        }
        assertThat("неверный список минус слов", getMinusKeywords(), containsInAnyOrder(expectedKeywords));
    }

    private void checkMetricaCounters(int[] expectedCounters) {
        if (expectedCounters == null) {
            return;
        }
        List<Integer> var = Ints.asList(expectedCounters);
        assertThat("неверный список счетчиков метрики", getAdditionalMetricaCounters(),
                hasItems(var.toArray(new Integer[var.size()])));
    }

    public void checkMetrikaValidationMessage(Matcher<WebElement> checkMatcher) {
        metrikaCountersPopupBlock.checkValidationMessage(checkMatcher);
    }

    public void fillInvalidDisabledDomain(List<String> disabledDomains) {
        openExtendedProperties();
        setDisabledDomainsButton.click();
        getDisabledDomainsPopupBlock().fillInvalidDisabledDomain(disabledDomains);
    }

    public void fillInvalidDisabledIps(List<String> disabledIps) {
        openExtendedProperties();
        setDisabledIPsButton.click();
        getDisabledIPsPopupBlock().fillInvalidDisabledIps(disabledIps);
    }

    public void fillNetworkTargeting(List<String> networkTargeting) {
        if (networkTargeting == null) {
            return;
        }
        fillRadio(networkTargetingRadio, StringUtils.join(networkTargeting, ","), RadioInputMethod.BY_VALUE);
    }

    public void fillDeviceTypeTargeting(List<String> deviceTypeTargeting) {
        if (deviceTypeTargeting == null) {
            return;
        }
        fillRadio(deviceTypeTargetingRadio, StringUtils.join(deviceTypeTargeting, ","), RadioInputMethod.BY_VALUE);
    }

    public void fillHierarchicalMultipliers(HierarchicalMultipliersWeb multipliersWeb) {
        if (multipliersWeb == null) {
            return;
        }
        changeAdjustmentRates.click();
        adjustmentRatesPopupBlock.fillParameters(multipliersWeb);
    }

    public void fillCampaignStrategyWithSuccess(StrategyWeb strategy) {
        openStrategyBlock();
        waitForElement(strategyPopup, 3, WebElementMatchers.isDisplayed());
        takeScreenshot();
        strategyPopup.fillStrategy(strategy);
        takeScreenshot();
        strategyPopup.clickSaveButton();
        waitForElement(strategyPopup, 5, not(WebElementMatchers.isDisplayed()));
    }

    public void checkCampaignStrategy(StrategyWeb expectedStrategy) {
        openStrategyBlock();
        waitForElement(strategyPopup, 3, WebElementMatchers.isDisplayed());
        takeScreenshot();
        strategyPopup.checkStrategy(expectedStrategy);
        strategyPopup.clickCancelButton();
        waitForElement(strategyPopup, 3, not(WebElementMatchers.isDisplayed()));
    }

    public String getRegionIDs() {
        Pattern pattern = Pattern.compile("\"geo\":\"[-0-9, ]*\"");
        java.util.regex.Matcher matcher = pattern.matcher(regionIDs.getAttribute("data-bem"));
        String result = null;
        if (matcher.find()) {
            return matcher.group(0).replaceAll("[\":]", "").replace("geo", "");
        }
        return result;
    }

    public CampaignTypeEnum getCampaignType() {
        return Stream.of(CampaignTypeEnum.values())
                .filter(t -> campaignType.getAttribute("class").contains("type_" + t.getValue().replace("_", "-")))
                .findFirst().orElseThrow(() -> new DirectWebError("Не удалось определить тип кампании"));
    }

    public List<String> getNetworkTargeting() {
        return Arrays.asList(networkTargetingRadio.getSelectedButton().getAttribute("value").split(","));
    }

    public List<String> getDeviceTypeTargeting() {
        return Arrays.asList(deviceTypeTargetingRadio.getSelectedButton().getAttribute("value").split(","));
    }

    public Boolean getNoTitleSubstitute() {
        return noTitleSubstitute.isSelected();
    }

    public Boolean getExtendedGeotargeting() {
        return extendedGeotargeting.isSelected();
    }

    public String getConsiderRivalsBanners() {
        return toDirectApiBooleanString(considerRivalsBanners.isSelected());
    }

    public String getStatusMetricaControl() {
        return toDirectApiBooleanString(statusMetricaControl.isSelected());
    }

    public String getFavoriteCampaign() {
        return toDirectApiBooleanString(favoriteCampaign.isSelected());
    }

    public Boolean getPayEmptyCamp() {
        if (exists().matches(payEmptyCamp)) {
            return payEmptyCamp.isSelected();
        }
        return null;
    }

    public List<String> getMinusKeywords() {
        return new Gson().fromJson(minusKeywords.getAttribute("value"), List.class);
    }

    public List<Integer> getAdditionalMetricaCounters() {
        return additionalMetrikaCounters.stream().map(counter -> parseInt(counter.getText()))
                .collect(Collectors.toList());
    }

    public List<String> getDisabledDomains() {
        return Arrays.asList(disabledDomains.getText().replaceAll(" ", "").split(","));
    }

    public List<String> getDisabledIps() {
        return Arrays.asList(disabledIps.getText().replaceAll(" ", "").split(","));
    }

    public void clickNext() {
        saveButton.click();
        alert().acceptIfTextMatches(
                equalTo(EditCampaignResource.OPENSTAT_METRIKA_LINKS_WILL_BE_TURNED_ON_MESSAGE.toString()));
    }

    public CampaignInfoWeb getCampaignInfoWeb(CampaignInfoWeb expectedCampInfo) {
        openExtendedProperties();
        return inAccordanceWith(expectedCampInfo).forNew(CampaignInfoWeb.class)
                .set("name", name, on(TextInput.class).getText())
                .set("startDate", startDate, on(CalendarInputBEM.class).getDate())
                .set("endDate", endDate, on(CalendarInputBEM.class).getDate())
                .set("geo", this, on(EditCampPage.class).getRegionIDs())
                .set("noTitleSubstitute", this, on(EditCampPage.class).getNoTitleSubstitute())
                .set("extendedGeotargeting", this, on(EditCampPage.class).getExtendedGeotargeting())
                .set("considerRivalsBanners", this, on(EditCampPage.class).getConsiderRivalsBanners())
                .set("statusMetricaControl", this, on(EditCampPage.class).getStatusMetricaControl())
                .set("favoriteCampaign", this, on(EditCampPage.class).getFavoriteCampaign())
                .set("payEmptyCamp", this, on(EditCampPage.class).getPayEmptyCamp())
                .set("bannersPerPage", bannersPerPage, on(TextInput.class).getText())
                .set("deviceTypeTargeting", this, on(EditCampPage.class).getDeviceTypeTargeting())
                .set("networkTargeting", this, on(EditCampPage.class).getNetworkTargeting())
                .set("attributionModel", this, on(EditCampPage.class).getAttributionModel())
                .set("appName", this::getAppName)
                .set("campaignGoal", this::getCampaignGoal)
                .getActualBean();
    }

    public void fillParameters(CampaignInfoWeb campaignInfo) {
        fillCampaignName(campaignInfo.getName());

        clickOnAdditionalPropertiesIfNotPresent();

        if (campaignInfo.getAppName() != null) {
            appSelect.selectApp(campaignInfo.getAppName());
        }
        if (campaignInfo.getCampaignGoal() != null) {
            campaignGoal.selectByValue(campaignInfo.getCampaignGoal().getValue());
        }
        inputDates(campaignInfo.getStartDate(), campaignInfo.getEndDate());
        fillNotifications(campaignInfo.getEmailNotification());
        fillSmsNotifications(campaignInfo.getSmsNotificationWeb());
        fillStrategy(campaignInfo.getStrategy(), campaignInfo.getContextStrategy());
        fillRegions(campaignInfo.getGeo(), true);
        fillMinusKeyWordsAndCheckPopupClosed(campaignInfo.getMinusKeywords());
        fillAdditionalRelevantPhrases(campaignInfo.getRelevantPhrases());
        if (campaignInfo.containsExtendedData()) {
            openExtendedProperties();
        }
        fillDisabledDomains(campaignInfo.getDisabledDomainsList());
        fillDisabledIPs(campaignInfo.getDisabledIpsList());
        setCheckboxState(noTitleSubstitute, campaignInfo.getNoTitleSubstitute());
        setCheckboxState(extendedGeotargeting, campaignInfo.getExtendedGeotargeting());
        fillConsiderRivalsBanners(campaignInfo.getConsiderRivalsBanners());
        fillStatusMetricaControl(campaignInfo.getStatusMetricaControl());
        fillMetricaCounters(campaignInfo.getAdditionalMetrikaCounters());
        fillAttributionModel(campaignInfo.getAttributionModel());
        setCheckboxState(favoriteCampaign, toBoolean(campaignInfo.getFavoriteCampaign()));
        setCheckboxState(payEmptyCamp, campaignInfo.getPayEmptyCamp());
        fillTextInput(bannersPerPage, campaignInfo.getBannersPerPage());
        fillDeviceTypeTargeting(campaignInfo.getDeviceTypeTargeting());
        fillNetworkTargeting(campaignInfo.getNetworkTargeting());
        fillHierarchicalMultipliers(campaignInfo.getHierarchicalMultipliersWeb());
    }

    private void fillAttributionModel(AttributionModelEnum attributionModel) {
        if (attributionModel == null) {
            return;
        }
        attributionModelSelect.selectByValue(attributionModel.getValue());
    }

    public void fillConsiderRivalsBanners(String considerTimeTargetValue) {
        if (considerTimeTargetValue == null) {
            return;
        }
        setCheckboxState(considerRivalsBanners, toBoolean(considerTimeTargetValue));
    }

    public void fillContactInfo(ContactInfoWeb contactInfo) {
        if (contactInfo != null) {
            useAddressAndPhone.select();
            getAddressAndPhoneBlock().fillParameters(contactInfo);
        } else {
            useAddressAndPhone.deselect();
        }
    }

    public void checkCampaignParameters(CampaignInfoWeb expectedCampInfo) {
        clickOnAdditionalPropertiesIfNotPresent();

        assertThat("неверные параметры кампании", getCampaignInfoWeb(expectedCampInfo),
                beanEquals(expectedCampInfo));
        checkEmailNotification(expectedCampInfo.getEmailNotification());
        checkSmsNotification(expectedCampInfo.getSmsNotificationWeb());
        checkDisabledDomains(expectedCampInfo.getDisabledDomainsList());
        checkDisabledIps(expectedCampInfo.getDisabledIpsList());
        checkMinusKeywords(expectedCampInfo.getMinusKeywords());
        checkAdditionalRelevantPhrases(expectedCampInfo.getRelevantPhrases());
        checkMetricaCounters(expectedCampInfo.getAdditionalMetrikaCounters());
        checkHierarchicalMultipliers(expectedCampInfo.getHierarchicalMultipliersWeb());
    }

    public void checkContactInfo(ContactInfoWeb contactInfo) {
        getAddressAndPhoneBlock().checkParameters(contactInfo);
    }

    public Button getEditTimeTargetingButton() {
        return changeTimeTargetButton;
    }

    public WebElement getTimeTargeting() {
        return timeTargetParameters;
    }

    public WebElement getContextStrategyParams() {
        return contextStrategyParameters;
    }

    public WebElement getCurrentStrategyParams() {
        return strategyParameters;
    }

    public WebElement getExpandedPropertiesBlock() {
        return expandedPropertiesBlock;
    }

    public void checkContextLimitSum(Matcher matcher) {
        getContextParametersPopupBlock().checkContextLimitSum(matcher);
    }

    public void checkContextPricePercent(Matcher matcher) {
        getContextParametersPopupBlock().checkContextPricePercent(matcher);
    }

    public void checkBidManagement(Matcher matcher) {
        timeTargetPopupBlock.checkBidManagement(matcher);
    }

    public void setServiceByManagerCheckBox(Boolean state) {
        setCheckboxState(serviceByManagerCheckBox, state);
    }

    public void clickOpenEmailNotifications() {
        changeEmailNotifications.click();
    }

    public void clickOpenSmsNotifications() {
        changeSmsNotifications.click();
    }

    public void clickOpenAdjustmentRates() {
        changeAdjustmentRates.click();
    }

    public void clickOpenRegion() {
        changeRegionButton.click();
    }

    public void clickOpenMinusKeywords() {
        setMinusKeywordsButton.click();
    }

    public void clickOpenMetrikaCounters() {
        setAdditionalMetrikaCountersButton.click();
    }

    public void clickOpenDisabledDomains() {
        setDisabledDomainsButton.click();
    }

    public void clickOpenDisabledIPs() {
        setDisabledIPsButton.click();
    }

    public void clickOpenDeviceTargeting() {
        setDeviceTargetingButton.click();
    }

    public void clickOpenAdditionalRelevantPhrases() {
        changeAdditionalRelevantPhrases.click();
    }

    public void clickOnAdditionalPropertiesIfNotPresent() {
        if (!additionalSettingsBlock.isDisplayed()) {
            additionalSettingsButton.click();
        }
    }

    public void clickOpenKeyGoalsPopup() {
        keyGoalsButton.click();
    }

    public void openKeyGoalsPopupAndOpenGoals() {
        clickOpenKeyGoalsPopup();
        keyGoalsPopup.clickOpenGoalsList();
    }

    @Override
    public IStrategyBlock getStrategyBlock(Class<? extends StrategyBemBlock> strategyBemBlockClass) {
        StrategyBemBlock strategyBlock = HtmlElementLoader.create(strategyBemBlockClass, config.getDriver());
        strategyBlock.setConfig(config);
        return strategyBlock;
    }

    @Override
    public void openStrategyBlock() {
        changeStrategyButton.click();
    }

    public List<Long> getChangedPlusRegionIds() {
        return new JsonParser().parse(changedRegions.getAttribute("value"))
                .getAsJsonObject().entrySet().stream()
                .filter(x -> StringUtils.isNumeric(x.getKey()) &&
                        x.getValue().getAsJsonObject().getAsJsonPrimitive("is_negative").getAsInt() != 1)
                .map(x -> Long.parseLong(x.getKey()))
                .collect(Collectors.toList());
    }

    public String getAppName() {
        String value;
        if (WebElementMatchers.exists().matches(appSelect)) {
            value = appSelect.getSelectedAppName();
        } else {
            value = appName.getText();
        }
        return value;
    }

    private CampaignInfoWeb.CampaignGoal getCampaignGoal() {
        return CampaignInfoWeb.CampaignGoal.deserialize(campaignGoal.getSelectedButton().getAttribute("value"));
    }

    public class NamedUrls {
        public static final String EDIT_CAMP = "edit.camp";
        public static final String EDIT_CAMP_FOR_LOGIN = "edit.camp.for.login";
        public static final String NEW_CAMP_FOR_LOGIN = "new.camp.for.login";
        public static final String NEW_CAMP_TYPE_FOR_LOGIN = "new.camp.type.for.login";
        public static final String NEW_CAMP = "new.camp";
        public static final String NEW_CAMP_TYPE = "new.camp.type";
        public static final String NEW_DYNAMIC_CAMP_FOR_LOGIN = "new.dynamic.camp.for.login";
        public static final String NEW_PERFOMANCE_CAMP_FOR_LOGIN = "new.perfomance.camp.for.login";
        public static final String SHOW_CAMP_SETTINGS = "show.camp.settings";
        public static final String NEW_MC_BANNER_CAMP_FOR_LOGIN = "new.mc.banner.camp.for.login";
    }
}
