package ru.yandex.autotests.direct.web.pages.campaigns;

import org.hamcrest.Matcher;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.campaigns.HelpRequestInfo;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.TextBlock;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * User: xy6er
 * Date: 16.05.13
 * Time: 23:23
 */

@NamedUrls({
        @NamedUrl(name = "order.campaign.optimizing.page", url = "/registered/main.pl?cmd=orderCampaignOptimizing")
})
public class OrderCampaignOptimizingPage extends BasePageObject {


    @Name("Поле Недельный бюджет кампании")
    @FindBy(xpath = ".//*[@id='budget']")
    private TextInput budgetInput;

    @Name("Чекбокс - Хочу улучшить тексты объявлений")
    @FindBy(xpath = ".//input[@value = 'Text']")
    private CheckBox improveTextCheckBox;

    @Name("Чекбокс - Хочу добавить ключевые слова")
    @FindBy(xpath = ".//input[@value = 'AddKeywords']")
    private CheckBox addKeywordCheckBox;

    @Name("Чекбокс - Хочу уточнить ключевые слова")
    @FindBy(xpath = ".//input[@value = 'SpecifyKeyword']")
    private CheckBox specifyKeywordCheckBox;

    @Name("Чекбокс - Хочу добавить адрес и телефон")
    @FindBy(xpath = ".//input[@value = 'AddAddress']")
    private CheckBox addAddressCheckBox;

    @Name("Чекбокс - Хочу добавить быстрые ссылки")
    @FindBy(xpath = ".//input[@value = 'AddSitelinks']")
    private CheckBox addSitelinksCheckBox;

    @Name("Чекбокс - Согласен")
    @FindBy(xpath = ".//input[@id = 'agree']")
    private CheckBox agreeCheckBox;

    @Name("Кнопка Заказать услугу")
    @FindBy(xpath = ".//input[@type = 'submit']")
    private Button submitOrderButton;

    @Name("Сообщение - Ваша заявка на услугу \"Первой помощи\" принята")
    @FindBy(css = "p.message-ok")
    private TextBlock acceptedOrderMessage;

    public void clickOnSubmitOrderButton() {
        submitOrderButton.click();
    }

    public void checkAcceptedOrderMessage(Matcher matcher) {
        assertThat(acceptedOrderMessage, matcher);
    }

    public void fillHelpRequestParameters(HelpRequestInfo helpRequestInfo) {
        fillTextInput(budgetInput, String.valueOf(helpRequestInfo.getBudget().intValue()));
        improveTextCheckBox.select();
        addKeywordCheckBox.select();
        specifyKeywordCheckBox.select();
        addAddressCheckBox.select();
        addSitelinksCheckBox.select();
        agreeCheckBox.select();
    }
}
