package ru.yandex.autotests.direct.web.pages.campaigns;

import java.util.List;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.strategy.objects.StrategyInfoWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.CampaignInfoWeb;
import ru.yandex.autotests.direct.web.pages.account.PayMethodsEnum;
import ru.yandex.autotests.direct.web.pages.account.PayPopupBlock;
import ru.yandex.autotests.direct.web.pages.account.PayPopupBlockNew;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.CampaignRow;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.CampaignsTableFooterBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.CampaignsTableHeaderBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.DayBudgetBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.HelpTeaserBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.InfoblockPopup;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.MassActionsBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.ShowCampLinksBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem.MetrikaCountersPopupBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.popups.VideoAdditionsPopup;
import ru.yandex.autotests.direct.web.pages.priceconstructor.IPriceConstructorProvider;
import ru.yandex.autotests.direct.web.pages.priceconstructor.PriceConstructorBem;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.MatcherDecorators;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static java.util.stream.Collectors.toList;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isDisplayed;


/**
 * User: buhter
 * Date: 12.02.13
 * Time: 13:06
 * Таблица кампаний клиента
 */

@NamedUrls({
        @NamedUrl(name = "show.camps.page", url = "/registered/main.pl?cmd=showCamps"),
        @NamedUrl(name = "show.client.camps.page", url = "/registered/main.pl?cmd=showCamps&ulogin={1}"),
        @NamedUrl(name = "disable.camps.page.sort",
                url = "/registered/main.pl?media_camps=0&settings_sorted=sDefault&sort=cid&reverse=0"),
        @NamedUrl(name = "disable.client.camps.page.sort",
                url = "/registered/main.pl?media_camps=0&ulogin={0}" +
                        "&settings_sorted=sDefault&sort=cid&reverse=0")
})

public class ShowCampsPage extends BasePageObject implements IPriceConstructorProvider {


    private HelpTeaserBlock helpTeaserBlock;

    public static class TabItem extends HtmlElement {
        @Name("Линка таба")
        @FindBy(xpath = ".//a")
        public Link tabLink;

        public Link getTabLink() {
            return tabLink;
        }

        public void checkTabLink(Matcher<WebElement> tabState) {
            assertThat("состояние ссылки таба " + getTabLink().getText() + " не соответствует ожидаемому",
                    getTabLink().getWrappedElement(),
                    tabState);
        }
    }

    private ShowCampLinksBlock showCampLinksBlock;

    @Name("Поле поиска")
    @FindBy(xpath = ".//span[contains(@class, 'b-search-on-list__input')]//input[@class='input__control']")
    private TextInput searchInput;

    @Name("Ошибка оплаты кампаний")
    @FindBy(xpath = ".//div[@class='b-campaigns-pay-error']")
    private WebElement paymentError;

    @Name("Ссылка на подключение общего счета")
    @FindBy(xpath = "//a[contains(@class, 'b-wallet-link__button')]")
    private WebElement walletEnableLink;

    @Name("Валюта")
    @FindBy(xpath = ".//div[contains(@class, 'b-campaigns-list__currency')]/strong")
    private WebElement currency;

    @Name("Кнопка 'Оплатить'")
    @FindBy(xpath = ".//div[contains(@class, 'b-campaigns-list__form-pay')]" +
            "/button[not(contains(@class, 'money_yandex'))]")
    private Button payButton;

    @Name("Кнопка 'Оплатить Яндекс.Деньгами'")
    @FindBy(xpath = ".//button[contains(@class, 'b-campaigns-list__button-pay_money_yandex')]")
    private Button yandexMoneyPayButton;

    @Name("Кнопка 'Выполнить'")
    @FindBy(xpath = ".//input[@name='mass_action']")
    private Button performMassActionButton;

    @Name("Выбор действий с выделенными кампаниями")
    @FindBy(xpath = ".//span[contains(@class, 'b-mass-actions__select')]")
    private SelectBEM selectCampaignActions;

    @Name("Список табов")
    @FindBy(xpath = ".//div[contains(@class, 'b-list-tabs__tab')]")
    private List<TabItem> tabList;

    @Name("Зарегистрированные представители")
    @FindBy(xpath = ".//a[contains(@href,'cmd=showClReps') and contains(@href,'ulogin')]")
    private Link registeredRepresentativesLink;

    @Name("главный представитель")
    @FindBy(xpath = ".//div[contains(@class,'b-additional-actions__personal-info')]//a[contains(@href,'mailto')]")
    private WebElement seniorRepresentative;

    @Name("Список кампаний")
    @FindBy(xpath = ".//tr[contains(@class, 'b-campaigns-list__row ') and " +
            "not(contains(@class, 'b-campaigns-list__row_hidden_yes'))]")
    public List<CampaignRow> campaignsRows;

    @Name("Ссылка 'Настройки пользователя'")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=userSettings')]")
    private Link userSettingsLink;

    @Name("Ссылка 'Платежи и документы'")
    @FindBy(xpath = ".//a[contains(@class, 'link_type_action') and contains(@href, 'invoices.xml?service_cc')]")
    private Link paymentsLink;

    @Name("Статистика по всем кампаниям")
    @FindBy(xpath = ".//a[@id='all_campaign_stat_link']")
    private Link showAllCampStatLink;

    @Name("Итоговое значение остатка")
    @FindBy(xpath = ".//tr[contains(@class,'b-campaigns-list__total')]" +
            "//div[contains(@class, 'b-list-numeric_type_sum-rest')]")
    private WebElement totalRest;

    @Name("Итоговое значение кликов")
    @FindBy(xpath = ".//tr[contains(@class, 'b-campaigns-list__total')]" +
            "//div[contains(@class, 'b-list-numeric_type_clicks')]")
    private WebElement totalClicks;

    @Name("Кнопка включения инфоблока")
    @FindBy(css = "span.b-infoblock__switcher")
    private WebElement toggleInfoBlockLink;

    private MetrikaCountersPopupBlock addMetrikaCountersPopup;

    private InfoblockPopup infoblockPopup;

    private CampaignsTableHeaderBlock campaignsListHeader;
    private CampaignsTableFooterBlock campaignsListFooter;

    private DayBudgetBlock dayBudgetBlock;

    @FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible ')]//div[contains(@class, 'b-offline-set-phrases-prices__content')]")
    private PriceConstructorBem offlineConstructor;

    private MassActionsBlock massActions;

    private VideoAdditionsPopup videoAdditionsPopup;

    public ShowCampLinksBlock inShowCampLinks() {
        return showCampLinksBlock;
    }

    @Name("Кнопка оплаты общего счета")
    @FindBy(xpath= ".//div[contains(@class, 'b-wallet-link__button')]//button")
    private Button payWalletButton;

    private PayPopupBlock payPopup;

    private PayPopupBlockNew payPopupBlockNew;

    @Override
    public PriceConstructorBem getConstructor() {
        offlineConstructor.setConfig(config);
        return offlineConstructor;
    }

    public DayBudgetBlock getDayBudgetBlock() {
        if (dayBudgetBlock != null) {
            dayBudgetBlock.setConfig(config);
        }
        return dayBudgetBlock;
    }

    public List<TabItem> getTabList() {
        return tabList;
    }

    public InfoblockPopup getInfoblockPopup() {
        return infoblockPopup;
    }

    /**
     * Получение таба по его названию
     *
     * @param tabName - название таба
     * @return - объект таба, если таб не найден пробрасывается Exception
     */
    public TabItem getTab(String tabName) {
        for (TabItem tabItem : tabList) {
            if (tabItem.getText().equalsIgnoreCase(tabName)) {
                return tabItem;
            }
        }
        throw new NullPointerException("Не найден таб '" + tabName + "'");
    }

    //Функция получения ряда таблицы кампаний по ID кампании
    public CampaignRow getCampaignRow(Long campaignId) {
        for (CampaignRow campaignRow : getCampaignsRows()) {
            if (!campaignRow.isLocked() &&
                    campaignRow.getViewCampaignLink().getReference().contains(campaignId.toString()))
            {
                new JavaScriptActions(config).scrollToElement(campaignRow);
                return campaignRow;
            }
        }
        return null;
    }

    public CampaignRow findCampaignRow(Long campaignId) {
        CampaignRow campaignRow = getCampaignRow(campaignId);
        if (campaignRow == null) {
            throw new DirectWebError("Не удалось найти кампанию " + campaignId);
        }
        new JavaScriptActions(config).scrollToElement(campaignRow);
        return campaignRow;
    }

    public List<CampaignInfoWeb> getAllCampaignsShortInfo() {
        return getCampaignsRows().stream()
                .map(x ->
                        new CampaignInfoWeb().withCampaignId(Long.valueOf(x.getCampaignNumberValue()))
                                .withSum(Double.parseDouble(x.getTotalValueText())))
                .collect(toList());
    }

    /**
     * Возвращает элемент кампании по её ID
     *
     * @param campId - ID кампании
     * @return - Строка кампании, если кампании нет, возвращается null
     */
    public CampaignRow getCampaign(Long campId) {
        for (CampaignRow campaign : getCampaignsRows()) {
            if (campaign.getCampaignNumberValue().equalsIgnoreCase(campId.toString())) {
                new JavaScriptActions(config).scrollToElement(campaign);
                return campaign;
            }
        }
        throw new DirectWebError("Кампания " + campId + " не найдена");
    }

    public List<CampaignRow> getCampaignsRows() {
        return campaignsRows;
    }

    public WebElement getWalletEnableLink() {
        return walletEnableLink;
    }

    public Button getPayButton() {
        return payButton;
    }

    public Button getYandexMoneyPayButton() {
        return yandexMoneyPayButton;
    }

    public WebElement getPaymentError() {
        return paymentError;
    }

    public TextInput getSearchInput() {
        return searchInput;
    }

    public HelpTeaserBlock getHelpTeaserBlock() {
        return helpTeaserBlock;
    }

    public ShowCampLinksBlock getShowCampLinksBlock() {
        return showCampLinksBlock;
    }

    public Link getRegisteredRepresentativesLink() {
        return registeredRepresentativesLink;
    }

    public WebElement getSeniorRepresentative() {
        return seniorRepresentative;
    }

    public CampaignsTableHeaderBlock getCampaignsListHeader() {
        return campaignsListHeader;
    }

    public MassActionsBlock getMassActions() {
        return massActions;
    }

    public Link getUserSettingsLink() {
        return userSettingsLink;
    }

    public Link getPaymentsLink() {
        return paymentsLink;
    }

    public WebElement getTotalRest() {
        return totalRest;
    }

    public WebElement getTotalClicks() {
        return totalClicks;
    }

    private PayPopupBlock getPayPopup() {
        payPopup.setConfig(config);
        return payPopup;
    }

    private PayPopupBlockNew getPayPopupBlockNew() {
        payPopupBlockNew.setConfig(config);
        return payPopupBlockNew;
    }

    public void fillDayBudgetParametersAndSave(Long campaignId, StrategyInfoWeb strategyInfoWeb) {
        CampaignRow campaignRow = getCampaign(campaignId);
        if (campaignRow == null) {
            throw new DirectWebError("Кампания не найдена " + campaignId);
        } else {
            campaignRow.clickEditDayBudgetButton();
            getDayBudgetBlock().fillParametersAndSave(strategyInfoWeb);
        }
    }

    public void openDayBudgetBlockForCampaign(Long campaignId) {
        CampaignRow campaignRow = getCampaign(campaignId);
        if (campaignRow == null) {
            throw new DirectWebError("Кампания не найдена " + campaignId);
        } else {
            campaignRow.clickEditDayBudgetButton();
        }
    }


    public void clickOnCampaignStatisticsLink(Long campaignId) {
        CampaignRow campaignRow = getCampaign(campaignId);
        if (campaignRow == null) {
            throw new DirectWebError("Не найдена кампания " + campaignId);
        } else {
            campaignRow.clickOnCampaignStatisticsLink();
        }
    }

    public void checkDayBudgetBlockAlert(Matcher<WebElement> matcher) {
        getDayBudgetBlock().checkAlert(matcher);
    }

    public void setSearchInputValue(String searchString) {
        getSearchInput().sendKeys(searchString);
    }

    public void clickYandexMoneyPayButton() {
        getYandexMoneyPayButton().click();
    }

    public void clickPayButton() {
        getPayButton().click();
    }

    public void clickOnRegisteredRepresentativesLink() {
        getShowCampLinksBlock().clickOnRegisteredRepresentativesLink();
    }

    public void clickUserSettingsLink() {
        getUserSettingsLink().click();
    }

    public void clickPaymentsLink() {
        getPaymentsLink().click();
    }

    public void clickShowAllCampStat() {
        showAllCampStatLink.click();
    }

    public void clickPriceOnCampaign(Long campaignId) {
        CampaignRow row = getCampaignRow(campaignId);
        if (row == null) {
            throw new DirectWebError("В таблице кампаний не найдено кампании с ID " + campaignId);
        } else {
            row.clickEditCampaignPriceLink();
        }
    }

    public void openInfoBlock() {
        if (!infoblockPopup.isDisplayed()) {
            toggleInfoBlockLink.click();
        }
    }

    public void clickHelpTeaserOrderServiceButton() {
        openInfoBlock();
        infoblockPopup.clickOrderServiceButton();
    }

    public void checkManageCampaignsInExcelLink(Matcher matcher) {
        getShowCampLinksBlock().checkManageCampaignsInExcelLink(matcher);
    }

    public void checkManageCampaignsWithApiLink(Matcher matcher) {
        getShowCampLinksBlock().checkManageCampaignsWithApiLink(matcher);
    }

    public void clickOnManageCampaignsWithApiLink() {
        getShowCampLinksBlock().clickOnManageCampaignsWithApiLink();
    }

    public void checkTransferFundsLink(Matcher matcher) {
        getShowCampLinksBlock().checkTransferFundsLink(matcher);
    }

    public void shouldSeeCampaignsList(Matcher matcher) {
        assertThat("неверный список кампаний", getCampaignsRows(), matcher);
    }

    public void shouldSeeRegisteredRepresentative(Matcher matcher) {
        assertThat(getRegisteredRepresentativesLink(), matcher);
    }

    public void checkSeniorRepresentative(Matcher matcher) {
        assertThat(getSeniorRepresentative().getText(), matcher);
    }

    public void checkStopCampaignLink(Long campaignId, Matcher matcher) {
        CampaignRow campaignRow = getCampaignRow(campaignId);
        if (campaignRow == null) {
            throw new DirectWebError("Не найдена кампания с ID = " + campaignId);
        } else {
            campaignRow.checkStopCampaignLink(matcher);
        }
    }

    public void checkResumeCampaignLink(Long campaignId, Matcher matcher) {
        CampaignRow campaignRow = getCampaignRow(campaignId);
        if (campaignRow == null) {
            throw new DirectWebError("Не найдена кампания с ID = " + campaignId);
        } else {
            campaignRow.checkResumeCampaignLink(matcher);
        }
    }

    public void checkManagerForCampaign(Long campaignId, Matcher matcher) {
        CampaignRow campaignRow = getCampaignRow(campaignId);
        if (campaignRow == null) {
            throw new DirectWebError("Не найдена кампания с ID = " + campaignId);
        } else {
            campaignRow.checkManager(matcher);
        }
    }

    public void checkPaymentError(Matcher matcher) {
        assertThat(getPaymentError().getText(),
                should(matcher).whileWaitingUntil(timeoutHasExpired((5000))));
    }

    public void checkHelpTeaserBlock() {
        if (!infoblockPopup.isDisplayed()) {
            toggleInfoBlockLink.click();
        }
        infoblockPopup.checkFirstHelpTeaserIsShown();
    }

    public void checkCampaignsListHeader(Matcher<CheckBox> displayedMatcher) {
        assertThat("состояние главного чекбокса отличается от ожидаемого",
                getCampaignsListHeader().getAllCheckbox(), displayedMatcher);
    }

    public void checkCampaignsTotalClicks(Matcher<WebElement> presenceMatcher) {
        assertThat("состояние суммы кликов отличается от ожидаемого",
                getTotalClicks(), presenceMatcher);
    }

    public void checkCampaignsTotalRest(Matcher<WebElement> presenceMatcher) {
        assertThat("состояние суммы остатков средств отличается от ожидаемого",
                getTotalRest(), presenceMatcher);
    }


    public void checkCurrency(Matcher<String> matcher) {
        assertThat(currency.getText(), matcher);
    }


    public void checkPriceOnCampaign(Long campaignId, Matcher matcher) {
        CampaignRow row = getCampaignRow(campaignId);
        if (row == null) {
            throw new Error("В таблице кампаний не найдено кампании с ID " + campaignId);
        } else {
            row.checkEditCampaignPriceLink(matcher);
        }
    }

    public void addMetrikaCountersAndCheckNotVisible(List<Long> metrikaCounters) {
        addMetrikaCountersAndCheckPopup(metrikaCounters, not(WebElementMatchers.exists()));
    }

    public void changeMetrikaCountersAndCheckNotVisible(List<Long> metrikaCounters) {
        fillMetrikaCounters(metrikaCounters);
        addMetrikaCountersPopup.clickOnReplaceButton();
        MatcherDecorators.should(not(WebElementMatchers.exists()))
                .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(4))).matches(addMetrikaCountersPopup);
    }

    public void deleteMetrikaCounters() {
        addMetrikaCountersPopup.clickOnDeleteButton();
        MatcherDecorators.should(not(WebElementMatchers.exists()))
                .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(4))).matches(addMetrikaCountersPopup);
    }

    public void addMetrikaCountersAndCheckPopup(List<Long> metrikaCounters, Matcher<WebElement> matcher) {
        fillMetrikaCounters(metrikaCounters);
        addMetrikaCountersPopup.clickOnAddButton();
        MatcherDecorators.should(matcher)
                .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(4))).matches(addMetrikaCountersPopup);
    }

    public void fillMetrikaCounters(String metrikaCounters) {
        if (metrikaCounters == null) {
            return;
        }
        addMetrikaCountersPopup.fillMetrikaCountersTextInput(metrikaCounters);

    }

    public void fillMetrikaCounters(List<Long> newMetrikaCounters) {
        String value = StringUtils.join(newMetrikaCounters, ", ");
        fillMetrikaCounters(value);
    }

    public void checkMetrikaValidationMessage(Matcher<WebElement> checkMatcher) {
        addMetrikaCountersPopup.checkValidationMessage(checkMatcher);
    }

    public void clickOnSelectVideo() {
        videoAdditionsPopup.clickChooseVideo();
    }

    public void payWallet(Float sum) {
        payWalletButton.click();
        waitForElement(getPayPopup(), 2, isDisplayed());
        getPayPopup().pay(sum);
    }

    public void payWalletWithNewForm(Float sum, PayMethodsEnum payMethod) {
        payWalletButton.click();
        waitForElement(getPayPopupBlockNew(), 2, isDisplayed());
        getPayPopupBlockNew().pay(sum, payMethod);
    }
}
