package ru.yandex.autotests.direct.web.pages.campaigns;

import java.util.ArrayList;
import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@NamedUrls({
        @NamedUrl(name = "show.info",
                url = "/registered/main.pl?cmd=showContactInfo&bid={1}&cid={2}")
})
public class ShowContactInfoPage extends BasePageObject { //todo Есть в проекте light, надо объединить


    @Name("Список периодов времени работы")
    @FindBy(css = "div.p-view-vcard-headless__worktime")
    private List<WebElement> timePeriods;

    private List<String> getTimePeriods() {
        List<String> periods = new ArrayList<>();
        for (WebElement timePeriod : timePeriods) {
            periods.add(timePeriod.getText().replace("\n", " "));
        }
        return periods;
    }

    public void checkTimePeriods(Matcher matcher) {
        assertThat("неверный список периодов", getTimePeriods(), matcher);
    }
}
