package ru.yandex.autotests.direct.web.pages.campaigns;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.web.data.banners.BannerActionsEnum;
import ru.yandex.autotests.direct.web.data.banners.BannerTabsEnum;
import ru.yandex.autotests.direct.web.data.firsthelp.OptimizeAction;
import ru.yandex.autotests.direct.web.data.firsthelp.recommendations.AcceptRecommendedBannerParameters;
import ru.yandex.autotests.direct.web.data.mediaplan.AcceptMediaplanParameters;
import ru.yandex.autotests.direct.web.data.mediaplan.MediaplanPhrasesMassActionType;
import ru.yandex.autotests.direct.web.data.priceconstructor.MediaplanTrafficVolume;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.ForecastInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.OptimizedBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.OptimizedPhraseInfoWeb;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.AcceptMediaplanPopup;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.OptimizeTextBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.SubmitOptimizePopup;
import ru.yandex.autotests.direct.web.pages.firsthelp.recommendations.blocks.popups.AcceptRecommendedBannersPopupBlock;
import ru.yandex.autotests.direct.web.pages.firsthelp.recommendations.blocks.popups.DeclineOptimizationPopupBlock;
import ru.yandex.autotests.direct.web.pages.firsthelp.recommendations.blocks.popups.RemoveRecommendationsPopupBlock;
import ru.yandex.autotests.direct.web.pages.mediaplans.blocks.MediaplanPhrasesBlock;
import ru.yandex.autotests.direct.web.pages.mediaplans.blocks.MediaplanTotalForecastRowBlock;
import ru.yandex.autotests.direct.web.pages.showcamp.blocks.BannerPreviewBlock;
import ru.yandex.autotests.direct.web.pages.showcamp.blocks.BannerTabsPanel;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.webelements.DirectButton;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.allure.webdriver.steps.AlertSteps;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.*;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

import static ch.lambdaj.Lambda.*;
import static com.google.common.collect.Iterables.getLast;
import static java.util.stream.Collectors.toList;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * User: xy6er
 * Date: 17.05.13
 * Time: 3:58
 */

@NamedUrls({
        @NamedUrl(name = "show.mediaplan.manager.page", url = "/registered/main.pl?cmd=showMediaplan&cid={1}&ulogin={2}"),
        @NamedUrl(name = "show.mediaplan.page", url = "/registered/main.pl?cmd=showMediaplan&cid={1}")
})
public class ShowMediaplanPage extends BasePageObject {


    @Name("Подставить цену входа в гарантированные показы")
    @FindBy(css = "span.b-phrases-list-group-operations__link_val_2")
    private Link setPricesForFirstPlace;

    @Name("Кнопка Сохранить ставки")
    @FindBy(xpath = ".//div[@id='actions-bar']//span[contains(@class,'save-btn')]" +
            "//input[@class = 'b-form-button__input']")
    private Button savePricesButton;

    @Name("Кнопка Закончить оптимизацию")
    @FindBy(css = "input.b-campinfo__optimize__accept-button")
    private Button acceptOptimizeButton;

    @Name("Не нуждается в оптимизации...")
    @FindBy(xpath = ".//input[@id='completeOptimizingButton']")
    private Button doesNotNeedOptimizationButton;

    @Name("Попап Закончить оптимизацию")
    private SubmitOptimizePopup submitOptimizePopup;

    @Name("Кнопка Принять рекомендованные объявления")
    @FindBy(css = "span.accept__accept-button input")
    private Button acceptRecommendationBannersButton;

    @Name("Кнопка подтвердить оптимизацию")
    @FindBy(xpath = ".//div[@id = 'acceptPopup']//input[@class = 'b-window__submit']")
    private Button submitOptimizeButton;

    @Name("Список действий с фразами")
    @FindBy(css = "select.b-mediaplan-view-phrases-actions__action")
    private Select phrasesActionsSelect;

    @Name("Кнопка Выполнить действие")
    @FindBy(css = "input.b-mediaplan-view-phrases-actions__submit")
    private Button executeAction;

    @Name("Текст - Заявленный клиентом месячный бюджет")
    @FindBy(css = "td.l-campinfo__right b")
    private TextBlock monthBudget;

    @Name("Блок 'Подробнее' об оптимизации")
    private OptimizeTextBlock optimizeTextBlock;

    @Name("Кнопка закончить медиаплан")
    @FindBy(xpath = ".//div[@id = 'actions-bar']//span[contains(@class, 'end-mediaplan__btn')]")
    protected Button finishMediaplanButton;

    @Name("Кнопка добавить еще блок на вкладке медиаплан")
    @FindBy(xpath = ".//form[@name='orderForm']//input[@type='submit']")
    private DirectButton addAnotherMediaplanBlockButton;

    @Name("Ссылка для выделения всех медиапланов")
    @FindBy(xpath = ".//a[contains(@class, 'select-all')]")
    private WebElement selectAllMediaplans;

    @Name("Кнопка 'Утвердить медиаплан'")
    @FindBy(xpath = ".//td[./form[@name='accept']]//input[@type='submit']")
    private DirectButton approveMediaplanButton;

    @Name("Текст статуса медиаплана")
    @FindBy(xpath = ".//div[contains(@class, 'campinfo__section')]/b")
    private WebElement mediaplanStatusText;

    @Name("Действия с фразами")
    @FindBy(xpath = ".//table[@class = 'b-campinfo__actions__layout-right']//span[contains(@class,'b-pseudo-link')]")
    private WebElement phrasesAction;

    @Name("Селект группового действия")
    @FindBy(xpath = ".//select[contains(@class, 'b-campaigninfo-show__action-select')]")
    protected Select groupAction;

    @Name("Ok button")
    @FindBy(xpath = ".//*[contains(@class, 'action-submit')]")
    public Button groupActionOkButton;

    private BannerTabsPanel bannerTabsPanel;

    protected List<BannerPreviewBlock> bannerPreviewBlocks;

    private MediaplanPhrasesBlock mediaplanPhrasesBlock;

    private List<MediaplanTotalForecastRowBlock> mediaplanTotalForecastRowBlocks;

    protected EndMediaplanPopupBlock endMediaplanPopupBlock;

    private AcceptMediaplanPopup acceptMediaplanPopup;

    private DeclineOptimizationPopupBlock declineOptimizationPopupBlock;

    private AcceptRecommendedBannersPopupBlock acceptRecommendedBannersPopupBlock;

    private RemoveRecommendationsPopupBlock removeRecommendationsPopupBlock;

    public AcceptRecommendedBannersPopupBlock getAcceptRecommendedBannersPopupBlock() {
        acceptRecommendedBannersPopupBlock.setConfig(config);
        return acceptRecommendedBannersPopupBlock;
    }

    public AcceptMediaplanPopup getAcceptMediaplanPopup() {
        acceptMediaplanPopup.setConfig(config);
        return acceptMediaplanPopup;
    }

    @Name("Кнопка принятия медиаплана")
    @FindBy(xpath = ".//td[contains(@class, 'actions__button')]//span[contains(@onclick, '#acceptpanel')]" +
            "//input[contains(@class, 'button__input')]")
    private Button acceptMediaplanButton;

    @Name("Блок где отображается результат действий")
    @FindBy(css = "div.b-campinfo__actions__info")
    private WebElement actionsInfo;

    @Name("Подставить цену объёма трафика 100")
    @FindBy(xpath = ".//span[contains(@class, 'group-operations__link_val_10')]")
    private WebElement setTrafficVolume100;

    @Name("Подставить цену объёма трафика 85")
    @FindBy(xpath = ".//span[contains(@class, 'group-operations__link_val_11')]")
    private WebElement setTrafficVolume85;

    @Name("Подставить цену объёма трафика 62")
    @FindBy(xpath = ".//span[contains(@class, 'phrases-list-group-operations__link_val_13')]")
    private WebElement setTrafficVolume62;

    @Name("Подставить цену объёма трафика 9")
    @FindBy(xpath = ".//span[contains(@class, 'phrases-list-group-operations__link_val_20')]")
    private WebElement setTrafficVolume9;

    @Name("Подставить цену объёма трафика 5")
    @FindBy(xpath = ".//span[contains(@class, 'phrases-list-group-operations__link_val_23')]")
    private WebElement setTrafficVolume5;

    @Name("Попап 'Действия с фразами'")
    @FindBy(xpath = ".//div[@class = 'b-campinfo__media-actions-block']")
    public static class PhrasesActionsPopup extends HtmlElement {

        @Name("Кнопка удалить дубли")
        @FindBy(xpath = ".//form[.//input[@value = 'mediaplanRemoveDoubles']]/span/input")
        protected Button removeDuplicates;

        @Name("Кнопка скоректировать пересечения")
        @FindBy(xpath = ".//form[.//input[@value = 'mediaplanRemoveIntersection']]/span/input")
        protected Button correctIntersection;
    }

    private PhrasesActionsPopup phrasesActionsPopup;

    @Name("Удалить рекомендации")
    @FindBy(xpath = ".//span[contains(@class, 'accept__reject-button')]")
    private Link removeRecommendationsLink;

    @Name("Попап 'Закончить медиаплан'")
    @FindBy(xpath = ".//div[@id = 'endMediaplanPopup']")
    public static class EndMediaplanPopupBlock extends HtmlElement {

        @Name("Кнопка отправить клиенту")
        @FindBy(xpath = ".//input[contains(@class, '__submit')]")
        protected Button sendToClientButton;
    }

    public void submitOptimize(OptimizeAction... optimizeActions) {
        savePricesButton.click();
        acceptOptimizeButton.click();
        for (OptimizeAction optimizeAction : optimizeActions) {
            submitOptimizePopup.selectOptimizeAction(optimizeAction);
        }
        submitOptimizeButton.click();
        config.getDriver().switchTo().alert().accept();
    }

    public void fillAcceptRecommendationParametersAndSubmit(AcceptRecommendedBannerParameters parameters) {
        acceptRecommendationBannersButton.click();
        getAcceptRecommendedBannersPopupBlock().fillParametersAndClickAccept(parameters);
    }

    public void proceedPhrasesAction(MediaplanPhrasesMassActionType action) {
        phrasesActionsSelect.selectByValue(action.getKey());
        executeAction.click();
    }

    public Double getMonthBudget() {
        Pattern pattern = Pattern.compile("\\d+.\\d{2}");
        java.util.regex.Matcher matcher = pattern.matcher(monthBudget.getText().replace(" ", ""));
        if (matcher.find()) {
            return Double.parseDouble(matcher.group());
        }
        throw new DirectWebError("Не найден недельный бюджет заявки");
    }

    public void checkBannerFrameBlocks(Matcher matcher) {
        assertThat("информация в списке баннеров не соответствует ожиданиям",
                bannerPreviewBlocks,
                matcher);
    }

    public void checkBannerPreviewParameters(BannerInfoWeb expectedBanner) {
        BannerPreviewBlock block = getBannerFrameBlock(expectedBanner.getBannerId());
        if (block == null) {
            throw new DirectWebError("Блок предпросмотра баннера медиаплана " + expectedBanner.getBannerId()
                    + " не найден");
        } else {
            block.checkParameters(expectedBanner);
        }
    }

    public void clickFinishMediaplanButton() {
        new JavaScriptActions(config).scrollToElement(finishMediaplanButton.getWrappedElement());
        finishMediaplanButton.click();
    }

    public void checkFinishMediaplanButton(Matcher matcher) {
        Assert.assertThat("кнопка 'Закончить медиаплан' на странице компании, не соответствует ожиданиям.",
                finishMediaplanButton, matcher);
    }

    public void clickSendToClientButton() {
        endMediaplanPopupBlock.sendToClientButton.click();
    }

    public void checkAddAnotherMediaplanBlockButton(Matcher matcher) {
        Assert.assertThat("кнопка 'Добавить еще блок' на странице компании соответствует ожиданиям.",
                addAnotherMediaplanBlockButton, matcher);
    }

    public void checkMediaplanStatusText(Matcher matcher) {
        Assert.assertThat("текст статуса медиаплана на странице компании соответствует ожиданиям.",
                mediaplanStatusText, matcher);
    }

    public void checkApproveMediaplanButton(Matcher matcher) {
        Assert.assertThat("кнопка 'Утвердить медиаплан' на странице компании соответствует ожиданиям.",
                approveMediaplanButton, matcher);
    }

    public void clickSelectAllMediaplans() {
        selectAllMediaplans.click();
    }

    public void checkBannerNumber(Long mediaplanID, Matcher matcher) {
        BannerPreviewBlock block = getBannerFrameBlock(mediaplanID);
        if (block == null) {
            throw new DirectWebError("Блок предпросмотра баннера медиаплана " + mediaplanID + " не найден");
        } else {
            block.checkBannerNumber(matcher);
        }
    }

    public Long getFirstBannerId() {
        if (bannerPreviewBlocks.size() > 0) {
            return bannerPreviewBlocks.get(0).getBannerId();
        }
        throw new DirectWebError("Не найден блок предпросмотра баннера");
    }

    public Long getLastBannerId() {
        if (bannerPreviewBlocks.size() > 0) {
            return getLast(bannerPreviewBlocks).getBannerId();
        }
        throw new DirectWebError("Не найден блок предпросмотра баннера");
    }

    public List<Long> getBannerIds() {

        if (bannerPreviewBlocks.size() > 0) {
            return bannerPreviewBlocks.stream()
                    .map(t -> t.getBannerId())
                    .collect(toList());
        }
        throw new DirectWebError("Не найден блок предпросмотра баннера");
    }

    public void clickEditMediaplan(Long mediaplanID) {
        BannerPreviewBlock block = getBannerFrameBlock(mediaplanID);
        if (block == null) {
            throw new DirectWebError("Блок предпросмотра баннера " + mediaplanID + " не найден");
        } else {
            block.clickEditMediaplan();
        }
    }

    public void selectMediaplanCheckBox(Long mediaplanID) {
        BannerPreviewBlock block = getBannerFrameBlock(mediaplanID);
        if (block == null) {
            throw new DirectWebError("Блок предпросмотра баннера " + mediaplanID + " не найден");
        } else {
            block.selectBannerCheckBox();
        }
    }

    public void clickCopyMediaplan(Long mediaplanID) {
        BannerPreviewBlock block = getBannerFrameBlock(mediaplanID);
        if (block == null) {
            throw new DirectWebError("Блок предпросмотра баннера " + mediaplanID + " не найден");
        } else {
            block.clickCopyMediaplan();
        }
    }

    public void clickDeleteMediaplan(Long mediaplanID) {
        BannerPreviewBlock block = getBannerFrameBlock(mediaplanID);
        if (block == null) {
            throw new DirectWebError("Блок предпросмотра баннера " + mediaplanID + " не найден");
        } else {
            block.deleteBanner();
            AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
        }
    }

    public void fillMinusKeywordsAndSave(Long mediaplanID, String minusKeywords) {
        BannerPreviewBlock block = getBannerFrameBlock(mediaplanID);
        if (block == null) {
            throw new DirectWebError("Блок предпросмотра баннера " + mediaplanID + " не найден");
        } else {
            block.fillMinusKeywordsAndSave(minusKeywords);
        }
    }

    private BannerPreviewBlock getBannerFrameBlock(Long mediaplanID) {
        for (BannerPreviewBlock block : bannerPreviewBlocks) {
            if (block.getBannerId().equals(mediaplanID)) {
                block.setConfig(config);
                return block;
            }
        }
        return null;
    }

    public Long getMediaplanIdByBannerId(Long bannerId) {
        for (BannerPreviewBlock block : bannerPreviewBlocks) {
            if (block.hasBannerIdAsMediaplanBlock(bannerId)) {
                return block.getBannerId();
            }
        }
        return null;
    }

    public void checkMediaplanFrameBlock(Long mediaplanID, Matcher matcher) {
        BannerPreviewBlock bannerPreviewBlock = getBannerFrameBlock(mediaplanID);
        assertThat("блок медиаплана не соответствует ожиданиям.", bannerPreviewBlock, matcher);
    }

    public void proceedAction(BannerActionsEnum action) {
        groupAction.selectByValue(action.getName());
        groupActionOkButton.click();
        AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
    }

    public void fillAcceptMediaplanParametersAndAccept(AcceptMediaplanParameters parameters) {
        acceptMediaplanButton.click();
        getAcceptMediaplanPopup().fillParametersAndClickAccept(parameters);
    }

    public void clickAddAnotherMediaplanBlockButton() {
        addAnotherMediaplanBlockButton.click();
    }

    public void declineOptimization(String comment) {
        doesNotNeedOptimizationButton.click();
        declineOptimizationPopupBlock.fillCommentAndAccept(comment);
    }

    public void checkActionsInfo(Matcher matcher) {
        assertThat("элемент с информацией о действии не соответствует ожиданиям", actionsInfo, matcher);
    }

    public void removeDuplicates() {
        phrasesAction.click();
        phrasesActionsPopup.removeDuplicates.click();
    }

    public void correctIntersection() {
        phrasesAction.click();
        phrasesActionsPopup.correctIntersection.click();
    }

    public void checkClientMonthBudget(org.hamcrest.Matcher matcher) {
        assertThat(getMonthBudget(), matcher);
    }

    public void savePrices() {
        savePricesButton.click();
    }

    public void expandOptimizeTextBlock() {
        optimizeTextBlock.expandTextBlock();
    }

    public void checkOptimizeText(org.hamcrest.Matcher matcher) {
        assertThat(optimizeTextBlock, matcher);
    }

    public void fillPhraseParameters(OptimizedPhraseInfoWeb phrase) {
        mediaplanPhrasesBlock.fillParameters(phrase);
    }

    public void checkPhraseParameters(OptimizedPhraseInfoWeb phrase) {
        mediaplanPhrasesBlock.checkParameters(phrase);
    }

    public void setTrafficVolume(MediaplanTrafficVolume priceType) {
        switch (priceType) {
            case FIVE:
                setTrafficVolume5.click();
                break;
            case HUNDRED:
                setTrafficVolume100.click();
                break;
        }
    }

    public void removeRecommendations(String comment) {
        removeRecommendationsLink.click();
        removeRecommendationsPopupBlock.fillCommentAndAccept(comment);
    }

    private MediaplanTotalForecastRowBlock getMediaplanTotalForecastRow(String mediaplanID) {
        for (MediaplanTotalForecastRowBlock mediaplanTotalForecastRowBlock : mediaplanTotalForecastRowBlocks) {
            if (mediaplanID.equals(mediaplanTotalForecastRowBlock.getBannerId()))
                return mediaplanTotalForecastRowBlock;
        }
        return null;
    }

    private ForecastInfoWeb getForecastFieldsAccordingForRow(ForecastInfoWeb expectedForecast,
                                                             MediaplanTotalForecastRowBlock totalForecastRow) {
        ForecastInfoWeb result = new ForecastInfoWeb();
        if (totalForecastRow != null) {
            result = inAccordanceWith(expectedForecast).forNew(ForecastInfoWeb.class)
                    .set("CTRForecast", totalForecastRow,
                            on(MediaplanTotalForecastRowBlock.class).getTotalCTRForecast())
                    .set("showsForecast", totalForecastRow,
                            on(MediaplanTotalForecastRowBlock.class).getTotalShowsForecast())
                    .set("clicksForecast", totalForecastRow,
                            on(MediaplanTotalForecastRowBlock.class).getTotalClicksForecast())
                    .set("budgetForecast", totalForecastRow,
                            on(MediaplanTotalForecastRowBlock.class).getTotalBudgetForecast())
                    .getActualBean();
        }
        result.setBannerId(expectedForecast.getBannerId());
        return result;
    }

    public ForecastInfoWeb getForecastForAllBannersFieldsAccording(ForecastInfoWeb expectedForecast) {
        MediaplanTotalForecastRowBlock totalForecastRow = getTotalForecastForAllBannersRow();
        ForecastInfoWeb result = getForecastFieldsAccordingForRow(expectedForecast, totalForecastRow);
        return result;
    }

    public ForecastInfoWeb getBannerForecastFieldsAccording(ForecastInfoWeb expectedForecast) {
        MediaplanTotalForecastRowBlock totalForecastRow = getMediaplanTotalForecastRow(
                String.valueOf(expectedForecast.getBannerId()));
        ForecastInfoWeb result = getForecastFieldsAccordingForRow(expectedForecast, totalForecastRow);
        return result;
    }

    public OptimizedBannerInfoWeb getOptimizedBannerFieldsAccording(OptimizedBannerInfoWeb expectedOptimizedBanner) {
        OptimizedBannerInfoWeb result = new OptimizedBannerInfoWeb();
        OptimizedPhraseInfoWeb optimizedPhrase = expectedOptimizedBanner.getOptimizedPhrases().get(0);
        optimizedPhrase.setBannerId(expectedOptimizedBanner.getBannerId());
        result.setOptimizedPhrases(getOptimizedPhraseListFieldsAccording(optimizedPhrase));
        result.setBannerId(expectedOptimizedBanner.getBannerId());
        if (expectedOptimizedBanner.getForecastInfoWeb() != null) {
            ForecastInfoWeb forecastInfoWeb = expectedOptimizedBanner.getForecastInfoWeb();
            forecastInfoWeb.setBannerId(expectedOptimizedBanner.getBannerId());
            result.setForecastInfoWeb(getBannerForecastFieldsAccording(forecastInfoWeb));
        }
        return result;
    }

    public void checkForecasts(ForecastInfoWeb expectedForecast,
                               BeanCompareStrategy compareStrategy) {
        ForecastInfoWeb actualForecast = getBannerForecastFieldsAccording(expectedForecast);
        assertThat("неверные параметры прогноза банера",
                actualForecast, beanEquals(expectedForecast).accordingStrategy(compareStrategy));
    }

    public void checkForecastsForAllBanners(ForecastInfoWeb expectedForecast,
                                            BeanCompareStrategy compareStrategy) {
        ForecastInfoWeb actualForecast = getForecastForAllBannersFieldsAccording(expectedForecast);
        assertThat("неверные параметры прогноза для всех баннеров",
                actualForecast, beanEquals(expectedForecast).accordingStrategy(compareStrategy));
    }

    public ForecastInfoWeb calculateTotalBannerForecast(OptimizedBannerInfoWeb expectedOptimizedBanner) {
        OptimizedPhraseInfoWeb optimizedPhrase = expectedOptimizedBanner.getOptimizedPhrases().get(0);
        optimizedPhrase.setBannerId(expectedOptimizedBanner.getBannerId());
        List<ForecastInfoWeb> phraseForecasts = extract(getOptimizedPhraseListFieldsAccording(optimizedPhrase),
                on(OptimizedPhraseInfoWeb.class).getForecastInfoWeb());
        ForecastInfoWeb forecastInfoWeb = calculateTotalForecasts(phraseForecasts);
        forecastInfoWeb.setBannerId(expectedOptimizedBanner.getBannerId());
        return forecastInfoWeb;
    }

    private List<OptimizedBannerInfoWeb> getAllOptimizedBanners(
            List<Long> bannerIDs, OptimizedBannerInfoWeb expectedOptimizedBanner) {
        List<OptimizedBannerInfoWeb> result = new LinkedList<>();
        for (Long bannerID : bannerIDs) {
            expectedOptimizedBanner.setBannerId(bannerID);
            result.add(getOptimizedBannerFieldsAccording(expectedOptimizedBanner));
        }
        return result;
    }

    private ForecastInfoWeb calculateTotalForecasts(List<ForecastInfoWeb> forecasts) {
        ForecastInfoWeb result = new ForecastInfoWeb();
        result.setCTRForecast((Double) avg(extract(forecasts,
                on(ForecastInfoWeb.class).getCTRForecast())));
        result.setShowsForecast((Integer) sum(extract(forecasts,
                on(ForecastInfoWeb.class).getShowsForecast())));
        result.setClicksForecast((Integer) sum(extract(forecasts,
                on(ForecastInfoWeb.class).getClicksForecast())));
        result.setBudgetForecast(new BigDecimal((Double) sum(extract(forecasts,
                on(ForecastInfoWeb.class).getBudgetForecast()))).setScale(2, RoundingMode.HALF_UP).doubleValue());
        return result;
    }

    public ForecastInfoWeb calculateForecastForAllBanners(List<Long> bannerIDs,
                                                          OptimizedBannerInfoWeb expectedOptimizedBanner) {
        List<OptimizedBannerInfoWeb> allOptimizedBanners = getAllOptimizedBanners(bannerIDs, expectedOptimizedBanner);
        List<ForecastInfoWeb> phraseForecasts = new LinkedList<>();
        for (OptimizedBannerInfoWeb optimizedBanner : allOptimizedBanners) {
            phraseForecasts.addAll(extract(optimizedBanner.getOptimizedPhrases(),
                    on(OptimizedPhraseInfoWeb.class).getForecastInfoWeb()));
        }
        return calculateTotalForecasts(phraseForecasts);

    }

    private MediaplanTotalForecastRowBlock getTotalForecastForAllBannersRow() {
        if (mediaplanTotalForecastRowBlocks.size() > 0) {
            return mediaplanTotalForecastRowBlocks.get(mediaplanTotalForecastRowBlocks.size() - 1);
        }
        return null;
    }

    public OptimizedPhraseInfoWeb getOptimizedPhraseFieldsAccording(OptimizedPhraseInfoWeb phrase) {
        return mediaplanPhrasesBlock.getFormFieldsAccording(phrase);
    }

    public Double getGuaranteeCTRForPhrase(OptimizedPhraseInfoWeb phrase) {
        return mediaplanPhrasesBlock.getGuaranteeCTRForPhrase(phrase);
    }

    public List<OptimizedPhraseInfoWeb> getOptimizedPhraseListFieldsAccording(
            OptimizedPhraseInfoWeb optimizedPhrase) {
        List<OptimizedPhraseInfoWeb> result = new LinkedList<>();
        for (String bannerPhrase :
                mediaplanPhrasesBlock.getPhrasesForBanner(optimizedPhrase.getBannerId())) {
            optimizedPhrase.setPhrase(bannerPhrase);
            result.add(getOptimizedPhraseFieldsAccording(optimizedPhrase));
        }
        return result;
    }

    public void clickOnWeekForecast() {
        mediaplanPhrasesBlock.clickOnWeekForecast();
    }

    public void clickOnMonthForecast() {
        mediaplanPhrasesBlock.clickOnMonthForecast();
    }

    public void selectBannersTab(BannerTabsEnum tab) {
        bannerTabsPanel.clickOnBannerTab(tab);
    }

    public void checkBannerTabCount(BannerTabsEnum bannerTab, Matcher matcher) {
        bannerTabsPanel.checkBannersTabCount(bannerTab, matcher);
    }
}
