package ru.yandex.autotests.direct.web.pages.campaigns;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import java.util.List;
import java.util.stream.Collectors;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created with IntelliJ IDEA.
 * User: alex-samo
 * Date: 01.11.13
 * Time: 15:53
 * To change this template use File | Settings | File Templates.
 */

@NamedUrls({
        @NamedUrl(name = "open.show.subclient.camps.page", url = "/registered/main.pl?cmd=showSubClientCamps")
})
public class ShowSubClientCampsPage extends BasePageObject {


    private List<CampaignRow> campaignsRows;

    /**
     * @return список ID кампаний со страницы кампаний
     */
    public List<Long> getCampaignIDList() {
        return extract(campaignsRows,
                on(CampaignRow.class).getCampaignID()).stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
    }

    public void checkCampaignIDList(Matcher<List<Long>> matcher) {
        assertThat("список номеров кампаний неверный", getCampaignIDList(), matcher);
    }

    @Name("Строка в таблице кампаний субклиентов")
    @FindBy(xpath = ".//tr[contains(@class,'b-campaigns-list-item')]")
    public static class CampaignRow extends HtmlElement {

        @Name("название кампании с номером")
        @FindBy(xpath = ".//h3[contains(@class, 'b-campaigns-list-item__title')]")
        private WebElement campaignNameAndID;

        @Name("Название кампании")
        @FindBy(xpath = ".//a[contains(@href, 'showCamp') and contains(@href, 'cid')]")
        public Link campaignName;

        public String getCampaignID() {
            String campaignNameAndID = this.campaignNameAndID.getText();
            campaignNameAndID = campaignNameAndID.substring(campaignName.getText().length(), campaignNameAndID.length());
            return campaignNameAndID.replace(" ", "").replace("(", "").replace("N", "").replace("№", "").replace(")", "");
        }
    }
}


