package ru.yandex.autotests.direct.web.pages.campaigns.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.mediaplan.AcceptMediaplanParameters;
import ru.yandex.autotests.direct.web.data.mediaplan.AcceptMediaplanTypeEnum;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Radio;
import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.element.TextInput;

/**
 * Created with IntelliJ IDEA.
 * User: alexey-n
 * Date: 30.09.13
 * Time: 16:06
 * To change this template use File | Settings | File Templates.
 */
@FindBy(xpath = ".//div[@id = 'acceptpanel']")
public class AcceptMediaplanPopup extends ExtendedHtmlElement {

    @Name("Способ принятия медиаплана")
    @FindBy(css = "select.b-ss__select")
    private Select acceptParameter;

    @Name("Оценка медиаплана")
    @FindBy(css = "select.b-media-accept-form__mark")
    private Select mediaplanRating;

    @Name("Радио начать показы/в черновик")
    @FindBy(xpath = ".//input[@id = 'show_now_yes_сh']")
    private Radio startViewingRadio;

    @Name("Радио добавить в новую/существующую кампанию")
    @FindBy(xpath = ".//input[@id = 'to_camp']")
    private Radio toCampRadio;

    @Name("Радио добавить объявления в новую кампанию или заменить старые")
    @FindBy(xpath = ".//input[@id = 'copy_or_replace_copy']")
    private Radio copyOrReplaceBannerRadio;

    @Name("ID Кампании")
    @FindBy(xpath = ".//input[@name = 'to_cid']")
    private TextInput toCampaignIDInput;

    @Name("Логин клиента")
    @FindBy(xpath = ".//input[@name = 'client_login']")
    private TextInput toClientLoginInput;

    @Name("Единая цена для всех объявлений")
    @FindBy(xpath = ".//input[@name = 'media_all_block_price_bid']")
    private WebElement unifiedPrice;

    @Name("Процент прибавки к ставкам")
    @FindBy(xpath = ".//input[@name = 'media_banners_prices_percent']")
    private TextInput priceIncrement;

    @Name("Кнопка принять")
    @FindBy(xpath = ".//input[contains(@class, 'media-accept-form__submit')]")
    private WebElement acceptButton;

    private void selectAcceptParameter(AcceptMediaplanTypeEnum type) {
        if (type == null) {
            return;
        }
        acceptParameter.selectByValue(type.getName());
    }

    private void selectStartViewing(Boolean startViewing) {
        if (startViewing == null) {
            return;
        }
        if (startViewing.equals(true)) {
            startViewingRadio.selectByValue("Yes");
        } else {
            startViewingRadio.selectByValue("No");
        }
    }

    private void inputPriceIncrement(Integer value) {
        if (value == null) {
            return;
        }
        priceIncrement.clear();
        priceIncrement.sendKeys(String.valueOf(value));
    }

    private void inputUnifiedPrice(Float value) {
        if (value == null) {
            return;
        }
        unifiedPrice.clear();
        unifiedPrice.sendKeys(String.valueOf(value));
        new JavaScriptActions(config).fireChangeEvent(unifiedPrice);
    }

    private void selectRating(Integer rating) {
        if (rating == null) {
            return;
        }
        mediaplanRating.selectByValue(Integer.toString(rating));
    }

    private void fillToNewCamp(Long campaignId, String login) {
        if (campaignId == null || login == null) {
            return;
        }

        toCampRadio.selectByValue("other");
        toCampaignIDInput.clear();
        toCampaignIDInput.sendKeys(campaignId.toString());
        toClientLoginInput.clear();
        toClientLoginInput.sendKeys(login);
    }

    private void selectReplaceOldBanner(Boolean replaceOldBanner) {
        if (replaceOldBanner == null) {
            return;
        }
        if (replaceOldBanner) {
            copyOrReplaceBannerRadio.selectByValue("replace");
        } else {
            copyOrReplaceBannerRadio.selectByValue("copy");
        }
    }

    public void fillParametersAndClickAccept(AcceptMediaplanParameters parameters) {
        selectAcceptParameter(parameters.getAcceptMediaplanType());
        selectStartViewing(parameters.isStartViewing());
        inputPriceIncrement(parameters.getPriceIncrement());
        inputUnifiedPrice(parameters.getCommonPrice());
        selectRating(parameters.getRating());
        fillToNewCamp(parameters.getNewCampaignId(), parameters.getNewClient());
        selectReplaceOldBanner(parameters.getReplaceOldBanner());
        takeScreenshot();
        acceptButton.click();
    }
}
