package ru.yandex.autotests.direct.web.pages.campaigns.blocks;

import org.hamcrest.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.data.showcampaigns.ActionLinks;
import ru.yandex.autotests.direct.web.data.showcampaigns.ShowCampsColumns;
import ru.yandex.autotests.direct.web.util.helpers.URLParameterHelper;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.*;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.RegexMatcher.matches;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.exists;

/**
 * User: buhter
 * Date: 08.11.13
 * Time: 15:44
 */
public class CampaignRow extends HtmlElement {
    @Name("Номер кампании")
    @FindBy(css = "h3.b-campaigns-list-item__title")
    private WebElement campaignNumberElement;

//        @Name("Порядковый номер")
//        @FindBy(xpath = ".//td[contains(@class, 'b-table__pos')]")
//        public WebElement campaignOrderNumber;

    @Name("Чекбокс кампании")
    @FindBy(xpath = ".//input[@class='checkbox__control']")
    private CheckBox campaignCheckbox;

    @Name("Позиция в списке")
    @FindBy(css = "div.b-campaigns-list-item__number-wrapper")
    private WebElement positionWrapper;

    @Name("Название кампании")
    @FindBy(xpath = ".//a[contains(@href, 'showCamp') and contains(@href, 'cid')]/span")
    private Link campaignName;

    @Name("Параметры Кампании")
    @FindBy(xpath = ".//a[( contains(@href, 'editCamp') and contains(@href, 'cid') ) " +
            "or (contains(@href, 'showCampSettings') and contains(@href, 'cid') )]")
    private WebElement campParamsLink;

    @Name("Остановить")
    @FindBy(xpath = ".//a[contains(@href,'cmd=stopCamp')]")
    private Link stopCampaignLink;

    @Name("Включить")
    @FindBy(xpath = ".//a[contains(@href,'resumeCamp')]")
    private Link resumeCampaignLink;

    @Name("Ссылка 'Удалить'")
    @FindBy(xpath = ".//a[contains(@href, 'delCamp') and contains(@href, 'cid')]")
    private WebElement deleteCampaignLink;

    @Name("Ссылка цена кампании")
    @FindBy(xpath = ".//span[contains(@class , 'b-offline-set-phrases-prices')]/button")
    private Button editCampaignPriceLink;

    @Name("Статистика по кампании")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=showStat')]")
    private Link campaignStatisticsLink;

    @Name("Ссылка на просмотр кампании")
    @FindBy(xpath = ".//a[contains(@href,'showCamp') and contains(@href,'cid=')]")
    private Link viewCampaignLink;

    @Name("Сумма на кампании")
    @FindBy(xpath = ".//td[@class='b-table__td b-table__numeric']" +
            "/following-sibling::td[@class='b-table__td b-table__numeric']")
    private WebElement campaignValue;

    @Name("Поле ввода суммы для пополнения кампании")
    @FindBy(xpath = ".//div[contains(@class,'b-campaigns-list-item__pay')]//input")
    private TextInput campaignPayInput;

    // Links
    @Name("Список ссылок действий")
    @FindBy(xpath = ".//div[@class = 'b-campaigns-list-item__actions']//a")
    private List<Link> linksList;

    public WebElement getCampaignNumber() {
        return campaignNumberElement;
    }

    // Columns
    @Name("Значение колонки 'Параметры'")
    @FindBy(xpath = ".//ul[@class='b-campaigns-list-item__settings']")
    public static class ParameterValue extends HtmlElement {
        @Name("Список параметров")
        @FindBy(xpath = ".//li[not(contains(@class, 'setting_disabled_yes'))]/span")
        private List<WebElement> valuesList;

        @Name("Список оберток параметров")
        @FindBy(xpath = ".//li[not(contains(@class, 'setting_disabled_yes'))]")
        private List<WebElement> valuesLiList;

        public List<WebElement> getValuesList() {
            return valuesList;
        }

        public List<WebElement> getValuesLiList() {
            return valuesLiList;
        }
    }

    @Name("Значение колонки 'Состояние'")
    @FindBy(xpath = ".//div[@class = 'b-campaigns-list-item__state']")
    private WebElement statusValue;

    @Name("Замок блокировки кампании")
    @FindBy(xpath = ".//span[contains(@class, 'icon_size-12_lock')]")
    private WebElement campaignLockIcon;

    @Name("Значение колонки 'Начало'")
    @FindBy(xpath = ".//div[@class='b-campaigns-list-item__date']/span")
    private WebElement startValue;

    @Name("Значение колонки 'Кликов'")
    @FindBy(xpath = ".//div[contains(@class, 'b-list-numeric_type_clicks')]")
    private WebElement clicksValue;

    @Name("Значение колонки 'Осталось у.е.'")
    @FindBy(xpath = ".//div[contains(@class, 'b-list-numeric_type_sum-rest')]")
    private WebElement totalValue;

    @Name("Значение колонки 'Сумма у.е.'")
    @FindBy(xpath = ".//div[contains(@class, 'b-list-numeric') and not(contains(@class, 'rest')) " +
            "and not(contains(@class, 'b-list-numeric_type_clicks'))]")
    private WebElement moneySumValue;

    @Name("")
    @FindBy(xpath = ".//button[contains(@class, 'day-budget__sum')]")
    private WebElement editDayBudgetButton;

    //для сервисируемого клиента
    @Name("Менеджер")
    @FindBy(xpath = ".//dl[@class='b-campaigns-list-item__info-dl']")
    private WebElement managerValue;

    public ParameterValue parametersValue;

    public TextInput getCampaignPayInput() {
        return campaignPayInput;
    }

    public Link getViewCampaignLink() {
        return viewCampaignLink;
    }

    public boolean isLocked() {
        return campaignNumberElement.getAttribute("class").contains("lockes_yes");
    }

    public Button getEditCampaignPriceLink() {
        return editCampaignPriceLink;
    }

    /**
     * Получение линки, соответствующей элементу enum'а
     *
     * @param actionLink - тип действия из enum ActionLinks
     * @return - объект линки или null, если такой линки нет
     */
    public Link getLink(ActionLinks actionLink) {
        if (actionLink == ActionLinks.SHOW_CAMPAIGN) {
            return this.campaignName;
        }

        List<Link> linksList = this.linksList;
        for (Link link : linksList) {
            if (URLParameterHelper.getUrlParameterByName(link.getReference(), "cmd").equals(actionLink.toString())) {
                return link;
            }
        }
        return null;
    }

    /**
     * Получение значения соответствующей элементу перечисления колонки по названию её поля в классе кампании
     *
     * @return - объект поля значения, если поле недоступно, пробрасывается Exception
     */
    public String getColumnValue(ShowCampsColumns column) {
        switch (column) {
            case NAME:
                return getCampaignName().getText();
            case CAMP_ID:
                return getCampaignNumberValue();
            case PARAMETERS:
                return getParametersValue().getText();
            case STATUS:
                return getStatusValue().getText();
            case START_TIME:
                return getStartValue().getText();
            case CLICKS:
                return getClicksValue().getText().replaceAll(" ", "");
            case TOTAL:
                return getTotalValue().getText().replaceAll(" ", "");
            case MONEY_SUM:
                return getMoneySumValue().getText();
            default:
                return null;
        }
    }

    public WebElement getEditDayBudgetButton() {
        return editDayBudgetButton;
    }

    public Link getResumeCampaignLink() {
        return resumeCampaignLink;
    }

    public Link getStopCampaignLink() {
        return stopCampaignLink;
    }

    public WebElement getDeleteCampaignLink() {
        return deleteCampaignLink;
    }

    public WebElement getTotalValue() {
        return totalValue;
    }

    public CheckBox getCampaignCheckbox() {
        return campaignCheckbox;
    }

    public Link getCampaignName() {
        return campaignName;
    }

    public WebElement getPositionWrapper() {
        return positionWrapper;
    }

    public List<Link> getLinksList() {
        return linksList;
    }

    public WebElement getStatusValue() {
        return statusValue;
    }

    public WebElement getCampaignLockIcon() {
        return campaignLockIcon;
    }

    public ParameterValue getParametersValue() {
        return parametersValue;
    }

    public WebElement getClicksValue() {
        return clicksValue;
    }

    public WebElement getMoneySumValue() {
        return moneySumValue;
    }

    public WebElement getStartValue() {
        return startValue;
    }

    public WebElement getManagerValue() {
        return managerValue;
    }

    public void selectCampaignCheckbox() {
        getCampaignCheckbox().select();
        assertThat("не открылась страница", getCampaignCheckbox().isSelected(),
                should(equalTo(true))
                        .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(1)))
        );
    }

    public void deselectCampaignCheckbox() {
        getCampaignCheckbox().deselect();
    }

    public String getCampaignNumberValue() {
        Pattern pattern = Pattern.compile("№ (\\d+)");
        java.util.regex.Matcher matcher = pattern.matcher(getCampaignNumber().getText());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
//        throw new DirectWebError("Cannot find campaign ID");
    }

    public void clickDeleteCampaignLink() {
        getDeleteCampaignLink().click();
    }

    public void clickEditDayBudgetButton() {
        getEditDayBudgetButton().click();
    }

    public void setCampaignPayInputValue(String sum) {
        getCampaignPayInput().clear();
        getCampaignPayInput().sendKeys(sum);
    }

    public void clickEditCampaignPriceLink() {
        getEditCampaignPriceLink().click();
    }

    public void clickOnCampaignStatisticsLink() {
        campaignStatisticsLink.click();
    }


    public void checkStopCampaignLink(Matcher matcher) {
        assertThat(getStopCampaignLink(), matcher);
    }

    public void checkResumeCampaignLink(Matcher matcher) {
        assertThat(getResumeCampaignLink(), matcher);
    }

    public void checkCampaignPayInput(Matcher matcher) {
        assertThat(getCampaignPayInput().getWrappedElement().getAttribute("value"), matcher);
    }

    public String getTotalValueText() {
        return getTotalValue().getText().replaceAll(" ", "");
    }

    public void checkTotalValue(Matcher matcher) {
        assertThat(Float.valueOf(getTotalValueText()), matcher);
    }

    public void checkCampaignCheckbox(Matcher<CheckBox> checkboxState) {
        assertThat("статус чекбокса кампании '" + getCampaignNumberValue() + "' отличается от ожидаемого",
                getCampaignCheckbox(),
                checkboxState);
    }

    public void checkCampaignName(Matcher matcher) {
        assertThat("неверное название кампании", getCampaignName().getText(), matcher);
    }

    public void checkIsCampaignMobile() {
        assertThat("кампания не является мобильной",
                getPositionWrapper().findElement(By.cssSelector(".b-campaigns-list-item__mobile-content-icon")), exists());
    }

    public void checkStatusValue(Matcher<String> equalToMatcher) {
        assertThat("статус кампании '" + getCampaignNumberValue() + "'отличается от ожидаемого",
                getStatusValue().getText(), equalToMatcher);
    }

    public void checkCampaignLockIcon(Matcher<WebElement> lockPresence) {
        assertThat("замок блокировки кампании '" + getCampaignNumberValue() + "' не отображается на странице",
                getCampaignLockIcon(), lockPresence);
    }

    public void checkParametersValue(Matcher<String> emptyMatcher) {
        assertThat("поле параметров кампании '" + getCampaignNumberValue() + "'пустое",
                getParametersValue().getText(), emptyMatcher);

    }

    public void checkClicksValue() {
        assertThat("формат поля 'Кликов' отличается от ожидаемого",
                getClicksValue().getText(), matches("-|[0-9]+"));
    }

    public void checkTotalValue() {
        assertThat("формат поля 'Осталось у.е.' отличается от ожидаемого",
                getTotalValue().getText(), matches("[0-9]+.[0-9][0-9]"));
    }

    public void checkMoneySumValue() {
        assertThat("формат поля 'Сумма у.е.' отличается от ожидаемого",
                getMoneySumValue().getText(), matches("[0-9]+.[0-9][0-9]"));
    }

    public void checkStartValue(String startDate) {
        assertThat("дата начала кампании отличается от указанной при создании",
                getStartValue().getText(), equalTo(startDate));
    }

    public void checkManager(Matcher matcher) {
        assertThat(getManagerValue(), matcher);
    }


    public void checkEditCampaignPriceLink(Matcher matcher) {
        assertThat("ссылка 'Цена' не соответствует ожиданиям", getEditCampaignPriceLink(), matcher);
    }
}
