package ru.yandex.autotests.direct.web.pages.campaigns.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.showcampaigns.ShowCampsColumns;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * Футер таблицы
 *
 * @author Vitaliy_Dobriyan
 */
@Name("Футер таблицы кампаний")
@FindBy(xpath = ".//tr[contains(@class, 'b-campaigns-list__total')]")
public class CampaignsTableFooterBlock extends HtmlElement {

    @Name("Итоговое значение кликов")
    @FindBy(xpath = ".//div[contains(@class, 'b-campaigns-list-numeric_type_clicks')]")
    public WebElement totalClicksValue;

    @Name("Итоговое значение 'Осталось у.е.'")
    @FindBy(xpath = ".//div[contains(@class, 'b-campaigns-list-numeric_type_sum-rest')]")
    public WebElement totalMoneyLeftValue;

    @Name("Итоговое pначение 'Сумма у.е.' в Архивных кампаниях")
    @FindBy(xpath = ".//div[contains(@class, 'b-campaigns-list-numeric_type_sum ')]")
    public WebElement moneySumValue;


    /**
     * Возвращает итоговый элемент соответствующего столбца по имени столбца
     *
     * @param columnName - имя столбца
     * @return - элемент итогового значения
     */
    public WebElement getColumnTotalValue(ShowCampsColumns columnName) {
        switch (columnName) {
            case CLICKS:
                return totalClicksValue;
            case TOTAL:
                return totalMoneyLeftValue;
            case MONEY_SUM:
                return moneySumValue;
            default:
                return null;
        }
    }
}
