package ru.yandex.autotests.direct.web.pages.campaigns.blocks;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.showcampaigns.SortParameters;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.popups.SortParametersPopUpBlock;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalToIgnoringCase;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;

/**
 * Заголовок таблицы
 *
 * @author Vitaliy_Dobriyan
 */
@Name("Шапка таблицы кампаний")
@FindBy(xpath = ".//tr[contains(@class, 'b-campaigns-list__head')]")
public class CampaignsTableHeaderBlock extends HtmlElement {

    public List<SortParametersPopUpBlock> sortParametersPopUp;

    @Name("Общий чекбокс")
    @FindBy(xpath = ".//input[@class = 'checkbox__control']")
    private CheckBox allCheckbox;

    @Name("Список ссылок для колонок")
    @FindBy(xpath = ".//a")
    private List<WebElement> columnsList;

    // Параметры
    @Name("Заголовок 'Параметры'")
    @FindBy(xpath = ".//td[contains(@class, 'b-campaigns-list__settings')]//button")
    private Button parametersHeader;

    @Name("Кнопка 'Сбросить сортировку'")
    @FindBy(xpath = ".//a[contains(@class, 'b-sort-link_type_reset')]")
    private WebElement resetSortParameters;

    @Name("Выбранный параметр сортировки")
    @FindBy(xpath = "..//tr[@class = 'b-campaigns-list__sort']//a")
    private WebElement selectedSortParameter;

    public CheckBox getAllCheckbox() {
        return allCheckbox;
    }

    public SortParametersPopUpBlock getSortParametersPopUp() {
        return getVisibleElement(sortParametersPopUp);
    }

    public void deselectAllCheckbox() {
        getAllCheckbox().deselect();
    }

    public WebElement getSelectedSortParameter() {
        return selectedSortParameter;
    }

    public WebElement getResetSortParameters() {
        return resetSortParameters;
    }

    public Button getParametersHeader() {
        return parametersHeader;
    }

    public List<WebElement> getColumnsList() {
        return columnsList;
    }

    public void selectParameter(SortParameters sortParameter) {
        getSortParametersPopUp().getParameterRadioButton().selectByValue(sortParameter.getParameterRadioValue());
    }

    public WebElement getSelectedParameter() {
        return getSortParametersPopUp().getParameterRadioButton().getSelectedButton();
    }

    public void checkSelectedParameter(SortParameters sortParameter) {
        assertThat("выбранный параметр сортировки не соответствует ожидаемому",
                getSelectedParameter().getAttribute("value"),
                equalToIgnoringCase(sortParameter.getParameterRadioValue()));
    }

    public void clickShowButton() {
        getSortParametersPopUp().getShowButton().click();
    }

    public void clickCancelButton() {
        getSortParametersPopUp().getCancelButton().click();
    }

    public void clickParametersLink() {
        getParametersHeader().click();
    }

    public void clickOnParametersCloseButton() {
        getResetSortParameters().click();
    }
}