package ru.yandex.autotests.direct.web.pages.campaigns.blocks;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.strategy.objects.StrategyInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.NumericInput;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TumblerBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * User: alexey-n
 * Date: 25.07.13
 * Time: 15:04
 */
@FindBy(xpath = ".//div[contains(@class,'b-wallet-day-budget-popup_js_inited')]")
@Name("Блок изменения дневного бюджета")
public class DayBudgetBlock extends ExtendedHtmlElement {

    @FindBy(xpath = ".//span[contains(@class, 'b-wallet-day-budget-control__switcher')]//input")
    public TumblerBEM dayBudgetSwitcher;

    @FindBy(xpath = ".//span[contains(@class,'b-wallet-day-budget-control__value-input')]/span/input")

    private NumericInput dayBudgetAmount;

    @FindBy(xpath = ".//span[contains(@class, 'b-wallet-day-budget-control__mode-select')]")
    public SelectBEM showModeSelect;

    @FindBy(xpath = ".//button[contains(@class, 'b-wallet-day-budget-popup__save')]")
    public Button saveButton;

    @FindBy(xpath = ".//div[contains(@class, 'b-wallet-day-budget-control__errors')]")
    private WebElement alertText;

    public WebElement getAlertTextElement() {
        return alertText;
    }


    public void fillParametersAndSave(StrategyInfoWeb strategyInfoWeb) {
        dayBudgetSwitcher.select();
        showModeSelect.selectByValue(strategyInfoWeb.getDayBudgetShowMode().name().toLowerCase());
        new WebElementsActions(config).setNumericValue(dayBudgetAmount
                , Double.toString(strategyInfoWeb.getDayBudgetSum()));
        new JavaScriptActions(config).fireBlurEvent(dayBudgetAmount.getWrappedElement());
        saveButton.click();
    }

    public void checkAlert(Matcher<WebElement> matcher) {
        assertThat("текст ошибки в блоке изменения дневного бюджета не соответствует ожиданиям",
                getAlertTextElement(), matcher);
    }

    public void checkAmount(Matcher matcher) {
        assertThat("значение дневного бюджета не соответствует ожиданиям",
                dayBudgetAmount, matcher);
    }

    public void checkShowMode(Matcher matcher) {
        assertThat("значение режима показа дневного бюджета не соответствует ожиданиям",
                showModeSelect.getSelectedText(), matcher);
    }
}
