package ru.yandex.autotests.direct.web.pages.campaigns.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 13.01.14
 */
@Name("Строка редактирования метки")
@FindBy(xpath = ".//div[contains(@class, 'p-edit-campaign-tags__camp-tag_tag-id')]")
public class EditTagRow extends HtmlElement {

    @Name("Текст метки")
    @FindBy(xpath = ".//input[contains(@name, 'tag_')]")
    private TextInput tagTextInput;

    @Name("Удалить метку")
    @FindBy(xpath = ".//div[contains(@class, 'p-edit-campaign-tags__delete-tag')]")
    private WebElement deleteTag;

    public void fillTagTextInput(String text) {
        fillTextInput(tagTextInput, text);
    }

    public String getTagText() {
        return tagTextInput.getText();
    }

    public void clickOnDeleteTag() {
        deleteTag.click();
    }


}
