package ru.yandex.autotests.direct.web.pages.campaigns.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

@FindBy(css = "div.b-infoblock__popup-content")
@Name("Инфоблок")
public class InfoblockPopup extends HtmlElement {

    private final int MAX_TEASERS_COUNT = 10;

    @Name("Кнопка пролистывания тизера вправо")
    @FindBy(css = "div.b-infoblock-teasers button.b-rotate-buttons__next")
    private Button listTeaserRightButton;

    @Name("Тизер первой помощи")
    @FindBy(css = "div.b-teaser_type_first-aid")
    private WebElement firstHelpTeaser;

    @Name("Блок кнопок пролистывания")
    @FindBy(css = "div.b-infoblock-teasers div.b-rotate-buttons")
    private WebElement listTeaserButtonBlock;

    @Name("Кнопка Заказать услугу")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=orderCampaignOptimizing')]")
    private Button orderServiceButton;

    public void clickOrderServiceButton() {
        checkFirstHelpTeaserIsShown();
        orderServiceButton.click();
    }

    public void checkFirstHelpTeaserIsShown() {
        boolean isTeaserShown = false;
        for (int i = 0; i < MAX_TEASERS_COUNT; i++) {
            if (WebElementMatchers.isDisplayed().matches(firstHelpTeaser)) {
                isTeaserShown = true;
                break;
            } else if (WebElementMatchers.isDisplayed().matches(listTeaserButtonBlock) &&
                    WebElementMatchers.isEnabled().matches(listTeaserRightButton.getWrappedElement())) {
                listTeaserRightButton.click();
            } else
                break;
        }
        if (!isTeaserShown) {
            throw new AssertionError("Тизер первой помощи не отображается!");
        }
    }


}
