package ru.yandex.autotests.direct.web.pages.campaigns.blocks;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;

import static org.junit.Assert.assertThat;

/**
 * Блок массовых действий с кампаниями
 *
 * @author Vitaliy_Dobriyan
 */
@Name("Массовые действия с кампаниями")
@FindBy(xpath = ".//div[contains(@data-bem, '\"b-mass-actions\"')]")
public class MassActionsBlock extends HtmlElement {

    @Name("Селект массовых действий")
    @FindBy(xpath = ".//span[contains(@class, 'b-mass-actions__select')]//select")
    public SelectBEM massActionsSelect;

    @Name("Кнопка 'Выполнить'")
    @FindBy(xpath = ".//button[contains(@class, 'b-mass-actions__button')]")
    public WebElement performButton;


    /**
     * Получение списка массовых действий селекта
     *
     * @return список массовых действий селекта
     */
    public List<String> getSelectOptions() {
        return getMassActionsSelect().getOptionsTextList();
    }


    public SelectBEM getMassActionsSelect() {
        return massActionsSelect;
    }

    public WebElement getPerformButton() {
        return performButton;
    }

    public void selectMassAction(String massAction) {
        getMassActionsSelect().selectByVisibleText(massAction);
    }

    public void clickPerformButton() {
        getPerformButton().click();
    }

    public void checkMassActionSelect(Matcher<TypifiedElement> stateMatcher) {
        assertThat("состояние селекта массовых действий не соответствует ожидаемому",
                getMassActionsSelect(),
                stateMatcher);
    }

    public void checkPerformButton(Matcher<WebElement> stateMatcher) {
        assertThat("состояние кнопки выполнения массовых действий не соответствует ожидаемому",
                getPerformButton(), stateMatcher);

    }

    public void checkMassActionsSelect(Matcher<Iterable<String>> matcher) {
        assertThat("список массовых действий не соответствует ожидаениям",
                getSelectOptions(), matcher);
    }
}
