package ru.yandex.autotests.direct.web.pages.campaigns.blocks;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;

@FindBy(css = ".b-mobile-app-selector__dropdown")
public class MobileAppSelect extends ExtendedHtmlElement {

    private static final String POPUP_SELECTOR = "//div[contains(@class, 'b-mobile-app-list__menu')]"
            + "[contains(@class, 'menu')]";

    public void selectApp(String appName) {
        if (!isSelectPopupVisible()) {
            clickOnOpenPopupButton();
        }
        WebElement selectPopup = getSelectPopup();
        waitForElement(selectPopup, 1000, WebElementMatchers.isDisplayed());
        selectPopup.findElements(By.xpath(".//div[contains(@class, 'b-mobile-app-item__app-info')]"))
                .stream()
                .filter(w -> w.getText().contains(appName))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("В списке не найдено приложение с названием " + appName))
                .click();
    }

    private WebElement getSelectPopup() {
        return findElement(By.xpath(POPUP_SELECTOR));
    }

    private boolean isSelectPopupVisible() {
        return WebElementMatchers.isDisplayed().matches(getSelectPopup());
    }

    private void clickOnOpenPopupButton() {
        findElement(By.xpath(".//button")).click();
    }

    public String getSelectedAppName() {
        return findElement(By.xpath(".//button//div[@class='b-mobile-app-item__app-info']")).getText();
    }
}
