package ru.yandex.autotests.direct.web.pages.campaigns.blocks;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@Name("Ссылки на странице всех кампаний")
@FindBy(xpath = ".//div[@class='p-campaigns__aux-actions']")
public class ShowCampLinksBlock extends HtmlElement {
    @Name("Ссылка условий ретаргетинга")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=showRetargetingCond')]")
    protected WebElement retargetingConditions;

    @Name("Зарегистрированные представители")
    @FindBy(xpath = ".//a[contains(@href,'cmd=showClReps') and contains(@href,'ulogin')]")
    private Link registeredRepresentativesLink;

    @Name("Управление кампаниями с помощью Excel")
    @FindBy(xpath = ".//a[contains(@href,'cmd=showExportedXlsList')]")
    private Link manageCampaignsInExcelLink;

    @Name("Ссылка 'Управление кампаниями с помощью API'")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=apiSettings')]")
    private Link manageCampsWithApiLink;

    @Name("Перенос средств с кампании на кампанию")
    @FindBy(xpath = ".//a[contains(@href,'cmd=transfer')]")
    private Link transferFundsLink;

    public WebElement getRetargetingConditions() {
        return retargetingConditions;
    }

    public void clickOnRegisteredRepresentativesLink() {
        registeredRepresentativesLink.click();
    }

    public void checkManageCampaignsInExcelLink(Matcher matcher) {
        assertThat(manageCampaignsInExcelLink, matcher);
    }

    public void clickOnManageCampaignsWithApiLink () {
        manageCampsWithApiLink.click();
    }

    public Link getManageCampsWithApiLink () {
        return manageCampsWithApiLink;
    }

    public void checkManageCampaignsWithApiLink(Matcher matcher) {
        assertThat(manageCampsWithApiLink, matcher);
    }


    public void checkTransferFundsLink(Matcher matcher) {
        assertThat(transferFundsLink, matcher);
    }
}
