package ru.yandex.autotests.direct.web.pages.campaigns.blocks;

import java.util.List;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.firsthelp.OptimizeAction;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

/**
 * User: xy6er
 * Date: 16.09.13
 * Time: 10:00
 */

@FindBy(xpath = ".//div[@id='acceptPopup']")
public class SubmitOptimizePopup extends HtmlElement {

    @Name("Список Групп")
    @FindBy(css = "span.b-comment-form-template__switcher")
    private List<Link> groupsLinkList;

    @Name("Список Чекбоксов")
    @FindBy(css = "input.checkbox-old")
    private List<CheckBox> actionsCheckBoxList;

    @Name("Закончить оптимизацию")
    @FindBy(css = "input.b-window__submit")
    private Button submitOptimizeButton;

    private Link getGroupLink(String label) {  //todo-b удалить как сделают таск DIRECT-24795
        for (Link link : groupsLinkList) {
            if (link.getText().equals(label)) {
                return link;
            }
        }
        throw new DirectWebError("Not found groupLink: " + label);
    }

    private CheckBox getActionCheckBox(String label) {
        for (CheckBox checkBox : actionsCheckBoxList) {
            if (checkBox.getLabelText().equals(label)) {
                return checkBox;
            }
        }
        throw new DirectWebError("Not found actionCheckBox: " + label);
    }

    public void selectOptimizeAction(OptimizeAction optimizeAction) {
        getGroupLink(optimizeAction.getGroup().toString()).click();
        getActionCheckBox(optimizeAction.getName()).select();
    }

    public void clickOnSubmitOptimizeButton() {
        submitOptimizeButton.click();
    }

}