package ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.objects.campaigns.parameters.CampaignContextStrategyWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.allure.webdriver.steps.AlertSteps;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanHelper.getOnlyFields;

@FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible')][.//div[contains(@class, 'b-context-limit')]]")
public class ContextParametersPopupBlock extends ExtendedHtmlElement implements IWebFrom<CampaignContextStrategyWeb> {
    @Name("Список Расход удерживать в пределах")
    @FindBy(css = "span.b-context-limit__limit select")
    private SelectBEM contextLimitSum;

    @Name("Список Максимальная цена за клик")
    @FindBy(css = "span.b-context-limit__price-coef select")
    private SelectBEM contextPricePercent;

    @Name("Не учитывать предпочтения пользователей")
    @FindBy(css = "span.b-context-limit__disable-behavior input")
    private CheckBoxBEM statusBehavior;

    @Name("Кнопка 'Сохранить'")
    @FindBy(css = "button.b-outboard-controls__accept-button")
    private Button saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(css = "button.b-outboard-controls__decline-button")
    private Button cancelButton;

    public String getContextLimitSumValue() {
        return contextLimitSum.getSelectedText().replace("%", "");
    }

    public String getContextPricePercent() {
        return contextPricePercent.getSelectedText().replace("%", "");
    }

    public void clickCancel() {
        cancelButton.click();
    }

    @Override
    public void fillParameters(CampaignContextStrategyWeb bean) {
        if (bean.getContextLimitSum() != null) {
            fillSelect(contextLimitSum, bean.getContextLimitSum() + "%", SelectInputMethod.BY_TEXT);
        }

        if (bean.getContextPricePercent() != null) {
            fillSelect(contextPricePercent, bean.getContextPricePercent() + "%", SelectInputMethod.BY_TEXT);
        }
        AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
        saveButton.click();
    }

    @Override
    public void checkParameters(CampaignContextStrategyWeb expectedBean) {
        CampaignContextStrategyWeb expected = getOnlyFields(expectedBean, "contextLimitSum", "contextPricePercent");
        assertThat("неверные параметры настроек для тематических площадок", getFormFieldsAccording(expectedBean),
                beanEquals(expected));
    }

    @Override
    public CampaignContextStrategyWeb getFormFieldsAccording(CampaignContextStrategyWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(CampaignContextStrategyWeb.class)
                .set("contextLimitSum", this,
                        on(ContextParametersPopupBlock.class).getContextLimitSumValue())
                .set("contextPricePercent", this,
                        on(ContextParametersPopupBlock.class).getContextPricePercent())
                .getActualBean();
    }

    public void checkContextLimitSum(Matcher matcher) {
        Assert.assertThat("предел расхода в процентах не соответствует ожиданиям",
                contextLimitSum, matcher);
        cancelButton.click();
    }

    public void checkContextPricePercent(Matcher matcher) {
        Assert.assertThat("максимальная цена за клик в процентах, не соответствует ожиданиям",
                contextPricePercent, matcher);
        cancelButton.click();
    }
}
