package ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.direct.web.data.textresources.EditCampaignResource;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.helpers.TextResourceHelper;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.apache.commons.lang3.StringUtils.join;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsString;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * Created by shmykov on 19.06.14.
 */
@FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible')][.//div[contains(@class, 'b-dont-show-domains')]]")
public class DisabledDomainsPopupBlock extends ExtendedHtmlElement {

    private final String VALUE_SEPARATOR = ", ";

    @Name("Поле ввода запрещенного домена")
    @FindBy(css = "span.b-dont-show-domains__input input")
    private TextInput domainInput;

    @Name("Чекбокс 'все'")
    @FindBy(css = "div.b-checkbox-tree-item__item_group_yes input")
    private CheckBoxBEM all;

    @Name("Кнопка 'Добавить'")
    @FindBy(css = "div.b-dont-show-domains__add button")
    private WebElement addButton;

    @Name("Кнопка 'Сохранить'")
    @FindBy(css = "button.b-outboard-controls__accept-button")
    private Button saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(css = "button.b-outboard-controls__decline-button")
    private Button cancelButton;

    @Name("Добавленные адреса")
    private List<domainRow> domainRows;

    @FindBy(xpath = "div.b-checkbox-tree-item__item_group_no")
    public static class domainRow extends HtmlElement {
        @Name("Чекбокс")
        @FindBy(xpath = ".//domainInput")
        public CheckBoxBEM checkBox;

        @Name("Название")
        @FindBy(xpath = ".//label")
        public WebElement domain;
    }

    @Name("Директовский алерт")
    @FindBy(xpath = "//div[contains(@class, 'popup_visibility_visible') and .//div[@class='b-confirm__message']]")
    private WebElement directAlert;

    @Name("Кнопка Ок в директовском алерте")
    @FindBy(xpath ="//div[contains(@class, 'popup_visibility_visible')" +
            " and .//div[@class='b-confirm__message']]//button[contains(@class, 'b-confirm__yes')]")
    private WebElement directAlertButton;


    public void fillParameters(List<String> domains) {
        clearAdded();
        fillTextInput(domainInput, join(domains, VALUE_SEPARATOR));
        addButton.click();
        saveButton.click();
    }

    public void fillInvalidDisabledDomain(List<String> domains) {
        fillTextInput(domainInput, join(domains, VALUE_SEPARATOR));
        addButton.click();

        TextResourceFormatter disabledDomainValidationMessage =
                TextResourceHelper.resource(EditCampaignResource.DISABLED_DOMAIN_VALIDATION_MESSAGE).args("ы", "ы");
        assertThat("алерт не появился",directAlert, WebElementMatchers.isDisplayed());
        assertThat("неверный текст алерта", directAlert.getText(),
                containsString(disabledDomainValidationMessage.toString() + ": " + join(domains, ", ")));
        directAlertButton.click();
        saveButton.click();
    }

    public void clearAdded() {
        if (domainRows.size() == 1) {
            domainRows.get(0).checkBox.deselect();
        } else if (domainRows.size() > 1) {
            all.deselect();
        }
    }
}
