package ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.textresources.EditCampaignResource;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.apache.commons.lang3.StringUtils.join;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsString;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * Created by shmykov on 19.06.14.
 */
@FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible')][.//div[contains(@class,'b-disabled-ips')]]")
public class DisabledIPsPopupBlock extends ExtendedHtmlElement {

    @Name("Поле ввода запрещенного адреса")
    @FindBy(css = "span.input input")
    private TextInput disabledIpInput;

    @Name("Кнопка добавить")
    @FindBy(css = ".b-disabled-ips_js_inited button")
    private Button addIP;

    @Name("Кнопка 'Сохранить'")
    @FindBy(css = "button.b-outboard-controls__accept-button")
    private Button saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(css = "button.b-outboard-controls__decline-button")
    private Button cancelButton;

    @Name("Добавленные IP")
    private List<IpRow> ipRows;

    @Name("Блок с чекбоксами адресов")
    @FindBy(css = "div.b-disabled-ips__ip")
    public static class IpRow extends HtmlElement {
        @Name("Чекбокс")
        @FindBy(xpath = ".//input")
        public CheckBoxBEM checkBox;

        @Name("Название")
        @FindBy(xpath = ".//label")
        public WebElement ip;
    }

    @Name("Директовский алерт")
    @FindBy(xpath = "//div[contains(@class, 'popup_visibility_visible') and .//div[@class='b-confirm__message']]")
    private WebElement directAlert;

    @Name("Кнопка Ок в директовском алерте")
    @FindBy(xpath ="//div[contains(@class, 'popup_visibility_visible')" +
            " and .//div[@class='b-confirm__message']]//button[contains(@class, 'b-confirm__yes')]")
    private WebElement directAlertButton;

    public void fillInvalidDisabledIps(List<String> ips) {
        fillTextInput(disabledIpInput, join(ips, " "));
        addIP.click();
        assertThat("алерт не появился",directAlert, WebElementMatchers.isDisplayed());
        assertThat("неверный текст алерта", directAlert.getText(),
                containsString(EditCampaignResource.DISABLED_IP_VALIDATION_MESSAGE.toString() + " " + StringUtils.join(ips, ", ")));
        directAlertButton.click();
        saveButton.click();
    }

    public void clearAdded() {
        if (ipRows.size() > 0) {
            for (IpRow ipRow : ipRows) {
                ipRow.checkBox.deselect();
            }
        }
    }

    public void fillParameters(List<String> bean) {
        clearAdded();
        fillTextInput(disabledIpInput, join(bean, " "));
        addIP.click();
        saveButton.click();
    }
}
