package ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem;

import java.util.ArrayList;
import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ch.lambdaj.Lambda.join;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@Name("Попап выбора ключевых целей на кампанию")
@FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible')][.//div[contains(@class,'b-edit-metrics-key-goals')]]")
public class KeyGoalsPopupBlock extends HtmlElement {

    @Name("Ценность конверсии")
    @FindBy(xpath = "//div[contains(@class, 'b-edit-metrics-key-goals-item__price')]//input")
    private TextInput keyGoalPrice;

    @Name("Открытие селекта с целями Метрики")
    @FindBy(css = "button.b-metrics-goal-selector__opener")
    private Button openGoalsList;

    @Name("Кнопка 'Сохранить'")
    @FindBy(css = "button.b-metrics-key-goals-popup__save")
    private Button saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(css = "button.b-metrics-key-goals-popup__cancel")
    private Button cancelButton;

    public void clickOpenGoalsList() {
        openGoalsList.click();
    }
}
