package ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem;

import java.util.ArrayList;
import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ch.lambdaj.Lambda.join;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible')][.//div[contains(@class,'b-metrika-counters')]]")
public class MetrikaCountersPopupBlock extends HtmlElement {

    @Name("Поле ввода номера счетчика")
    @FindBy(css = "input.input__control")
    private TextInput counterInput;

    @Name("Кнопка 'Сохранить'")
    @FindBy(css = "button.b-metrika-counters-popup__accept-button")
    private Button saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(css = "button.b-metrika-counters-popup__decline-button")
    private Button cancelButton;

    @Name("Кнопка 'Добавить'")
    @FindBy(css = "button.b-metrika-counters-popup__add-button")
    private Button addButton;

    @Name("Кнопка 'Заменить'")
    @FindBy(css = "button.b-metrika-counters-popup__replace-button")
    private Button replaceButton;

    @Name("Кнопка 'Удалить все'")
    @FindBy(css = "button.b-metrika-counters-popup__delete-button")
    private Button deleteButton;

    @Name("Сообщение валидации")
    @FindBy(css = ".b-metrika-counters__error")
    private WebElement validationMessage;

    private String getCountersAsString(int... counters) {
        List<String> strings = new ArrayList<>();
        for (int counter : counters) {
            strings.add(String.valueOf(counter));
        }
        return join(strings, ",");
    }

    public void fillParameters(int... counters) {
        fillTextInput(counterInput, getCountersAsString(counters));
        if (saveButton.isEnabled()) {
            saveButton.click();
        }
    }

    public void fillMetrikaCountersTextInput(String metrikaCounters) {
        fillTextInput(counterInput, metrikaCounters);
    }

    public void clickOnSaveButton() {
        saveButton.click();
    }

    public void clickOnAddButton() {
        addButton.click();
    }

    public void clickOnReplaceButton() {
        replaceButton.click();
    }

    public void clickOnDeleteButton() {
        deleteButton.click();
    }

    public void checkValidationMessage(Matcher<WebElement> checkMatcher) {
        assertThat("предупреждение валидации не появилось", validationMessage, WebElementMatchers.isDisplayed());
        assertThat("текст валидации не верный", validationMessage, checkMatcher);
    }
}
