package ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem;

import org.hamcrest.Matcher;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.webelements.bem.TextAreaBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

import static org.apache.commons.lang3.StringUtils.join;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible') and .//div[contains(@class, 'b-minus-words-control__popup')]]")
@Name("Поп-ап задания 'Единые минус-слова для всех фраз кампании'")
public class MinusKeyWordsPopupBlock extends ExtendedHtmlElement {

    @Name("Поле ввода минус-слов")
    @FindBy(xpath = ".//textarea")
    private TextAreaBEM minusKeyWordsInput;

    @Name("Счетчик символов")
    @FindBy(css = "div.input__counter")
    private WebElement minusKeyWordsSymbolCounter;

    @Name("Кнопка 'Сохранить'")
    @FindBy(xpath = ".//button[contains(@class,'b-outboard-controls__accept-button')]")
    private Button saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(xpath = ".//button[contains(@class,'b-outboard-controls__decline-button')]")
    private Button cancelButton;

    public void fillParameters(String[] bean) {
        if (bean == null) {
            return;
        }
        fillTextInput(minusKeyWordsInput, join(bean, ", "));
        saveButton.click();
    }

    public void fillLongParametersWithoutSave(String[] bean) {
        if (bean == null) {
            return;
        }
        ((JavascriptExecutor)config.getDriver()).executeScript("$('.b-minus-words .input').bem('input').val(arguments[0])", join(bean, ", "));
    }

    public void checkSaveButton(Matcher<WebElement> matcher) {
        assertThat("кнопка 'Сохранить' в попапе не соответствует ожиданиям",
                saveButton.getWrappedElement(), matcher);
    }
}
