package ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.objects.campaigns.RelevantPhrasesInfo;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TumblerBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

@FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible')][.//div[contains(@class, 'b-campaign-broadmatch')]]")
public class RelevantPhrasesPopupBlock extends ExtendedHtmlElement {
    @Name("Чек-бокс показов по дополнительным релевантным фразам")
    @FindBy(xpath = ".//div[contains(@class,'b-campaign-broadmatch__switcher-row')]//input")
    private TumblerBEM addRelevantPhrases;

    @Name("Максимальный расход от общего расхода кампании")
    @FindBy(xpath = ".//span[contains(@class, 'b-campaign-broadmatch__limit')]//input")
    private TextInput relevantPhrasesBudgetLimit;

    @Name("Оптимизация конверсии по цели")
    @FindBy(xpath = ".//div[contains(@class,'b-campaign-broadmatch__goals-settings')]//select")
    private SelectBEM relevantPhrasesGoal;

    @Name("Кнопка 'Сохранить'")
    @FindBy(css = "button.b-campaign-broadmatch__accept-button")
    private Button saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(css = "button.b-campaign-broadmatch__decline-button")
    private Button cancelButton;

    public Boolean getAddRelevantPhrases() {
        return addRelevantPhrases.isSelected();
    }

    public Integer getBudgetLimitSumValue() {
        return Integer.valueOf(relevantPhrasesBudgetLimit.getText());
    }

    public String getRelevantPhrasesGoals() {
        return relevantPhrasesGoal.getSelectedText();
    }

    private void fillAddRelevantPhrases(Boolean value) {
        if (value == null) {
            return;
        }
        setCheckboxState(addRelevantPhrases, value);
    }

    private void fillRelevantPhrasesBudgetLimit(Integer value) {
        if (value == 0 || value == null) {
            return;
        }
        relevantPhrasesBudgetLimit.clear();
        relevantPhrasesBudgetLimit.sendKeys(value.toString());
    }

    private void fillRelevantPhrasesGoal(String goal) {
        if (goal == null) {
            return;
        }
        relevantPhrasesGoal.selectByValue(goal);
    }

    private void clickSave() {
        saveButton.click();
    }

    public void clickCancel() {
        cancelButton.click();
    }

    public void fillParameters(RelevantPhrasesInfo bean) {
        if (bean.getAddRelevantPhrases() != null) {
            setCheckboxState(addRelevantPhrases, bean.getAddRelevantPhrases());
        }

        if (bean.getBudgetLimit() != null) {
            fillRelevantPhrasesBudgetLimit(bean.getBudgetLimit());
        }

        if (bean.getGoal() != null) {
            fillSelect(relevantPhrasesGoal, bean.getGoal(), SelectInputMethod.BY_TEXT);
        }
        saveButton.click();
    }

    public void checkParameters(RelevantPhrasesInfo expectedBean) {
        assertThat("неверные параметры настроек для тематических площадок", getFormFieldsAccording(expectedBean),
                beanEquals(expectedBean));
    }

    private RelevantPhrasesInfo getFormFieldsAccording(RelevantPhrasesInfo expectedBean) {
        return inAccordanceWith(expectedBean).forNew(RelevantPhrasesInfo.class)
                .set("addRelevantPhrases", this, on(RelevantPhrasesPopupBlock.class).getAddRelevantPhrases())
                .set("budgetLimit", this, on(RelevantPhrasesPopupBlock.class).getBudgetLimitSumValue())
                .set("goal", this, on(RelevantPhrasesPopupBlock.class).getRelevantPhrasesGoals())
                .getActualBean();
    }
}
