package ru.yandex.autotests.direct.web.pages.campaigns.blocks.bem;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.objects.campaigns.parameters.SmsNotificationInfoWeb;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.HoursPeriodInputBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.steps.BackendSteps.toBoolean;
import static ru.yandex.autotests.direct.web.steps.BackendSteps.toDirectApiBooleanString;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

@Name("Попап email уведомлений")
@FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible')][.//div[contains(@class, 'b-sms-notification')]]")
public class SmsNotificationsPopupBlock extends HtmlElement implements IWebFrom<SmsNotificationInfoWeb> {

    @Name("Уведомление об остатке средств")
    @FindBy(css = "span.b-sms-notification__active-orders-money-out-sms input")
    private CheckBoxBEM moneyOutSms;

    @Name("Уведомление об окончании кампании")
    @FindBy(css = "span.b-sms-notification__camp-finished-sms input")
    private CheckBoxBEM endOfCampaign;

    @Name("Уведомление о результатах модерации")
    @FindBy(css = "span.b-sms-notification__moderate-result-sms input")
    private CheckBoxBEM moderateResultSms;

    @Name("Уведомление о поступлении средств")
    @FindBy(css = "span.b-sms-notification__notify-order-money-in-sms input")
    private CheckBoxBEM moneyInSms;

    @FindBy(xpath = ".//div[contains(@class, 'b-worktime__wrapper')]")
    private HoursPeriodInputBEM smsTime;

    @Name("Кнопка 'Сохранить'")
    @FindBy(css = "button.b-outboard-controls__accept-button")
    private Button saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(css = "button.b-outboard-controls__decline-button")
    private Button cancelButton;

    private void fillTime(String timeFrom, String timeTo) {
        if (timeFrom == null && timeTo == null)
            return;
        String[] timeValuesFrom = timeFrom.split(":");
        fillSelect(smsTime.periodStartTimeInHoursSelect, timeValuesFrom[0], SelectInputMethod.BY_TEXT);
        fillSelect(smsTime.periodStartTimeInMinutesSelect, timeValuesFrom[1], SelectInputMethod.BY_TEXT);

        String[] timeValuesTo = timeTo.split(":");
        fillSelect(smsTime.periodEndTimeInHoursSelect, timeValuesTo[0], SelectInputMethod.BY_TEXT);
        fillSelect(smsTime.periodEndTimeInMinutesSelect, timeValuesTo[1], SelectInputMethod.BY_TEXT);
    }

    public String getMoneyOutSms() {
        return toDirectApiBooleanString(moneyOutSms.isSelected());
    }

    public String getEndOfCampaign() {
        return toDirectApiBooleanString(endOfCampaign.isSelected());
    }

    public String getModerateResultSms() {
        return toDirectApiBooleanString(moderateResultSms.isSelected());
    }

    public String getMoneyInSms() {
        return toDirectApiBooleanString(moneyInSms.isSelected());
    }

    public void clickCancel() {
        cancelButton.click();
    }

    @Override
    public void fillParameters(SmsNotificationInfoWeb bean) {
        setCheckboxState(moneyOutSms, toBoolean(bean.getMoneyOutSms()));
        setCheckboxState(endOfCampaign, toBoolean(bean.getEndOfCampaign()));
        setCheckboxState(moderateResultSms, toBoolean(bean.getModerateResultSms()));
        setCheckboxState(moneyInSms, toBoolean(bean.getMoneyInSms()));
        fillTime(bean.getSmsTimeFrom(), bean.getSmsTimeTo());
        saveButton.click();
    }

    @Override
    public SmsNotificationInfoWeb getFormFieldsAccording(SmsNotificationInfoWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(SmsNotificationInfoWeb.class)
                .set("moneyOutSms", this, on(SmsNotificationsPopupBlock.class).getMoneyOutSms())
                .set("endOfCampaign", this, on(SmsNotificationsPopupBlock.class).getEndOfCampaign())
                .set("moderateResultSms", this, on(SmsNotificationsPopupBlock.class).getModerateResultSms())
                .set("moneyInSms", this, on(SmsNotificationsPopupBlock.class).getMoneyInSms())
                .set("smsTimeFrom", smsTime, on(HoursPeriodInputBEM.class).getStartTime())
                .set("smsTimeTo", smsTime, on(HoursPeriodInputBEM.class).getEndTime())
                .getActualBean();
    }

    @Override
    public void checkParameters(SmsNotificationInfoWeb info) {
        assertThat("неверные параметры смс-нотификаций", getFormFieldsAccording(info), beanEquals(info));
    }
}
